<?php
// فعال کردن نمایش خطاها
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// خواندن لاگ خطاهای PHP
echo "<html><head><meta charset='utf-8'></head><body>";
echo "<h1>📋 لاگ خطاهای PHP</h1>";
echo "<hr>";

// بررسی error_log سرور
$error_logs = [
    'settings/error_log' => 'Error Log اصلی',
    'php_errors.log' => 'PHP Errors Log',
    'bot_errors.txt' => 'Bot Errors',
    'debug_log.txt' => 'Debug Log'
];

foreach($error_logs as $file => $title) {
    echo "<h2>$title ($file)</h2>";
    
    if(file_exists($file)) {
        $content = file_get_contents($file);
        
        if(!empty($content)) {
            // نمایش 100 خط آخر
            $lines = explode("\n", $content);
            $last_lines = array_slice($lines, -100);
            
            echo "<div style='background:#f5f5f5;padding:15px;border-radius:5px;max-height:400px;overflow:auto;'>";
            echo "<pre>" . htmlspecialchars(implode("\n", $last_lines)) . "</pre>";
            echo "</div>";
            
            // دکمه پاک کردن
            echo "<form method='post' style='margin:10px 0;'>";
            echo "<button type='submit' name='clear' value='$file' style='background:#dc3545;color:white;border:none;padding:8px 16px;border-radius:4px;cursor:pointer;'>🗑️ پاک کردن این لاگ</button>";
            echo "</form>";
        } else {
            echo "<p style='color:green;'>✅ این لاگ خالی است</p>";
        }
    } else {
        echo "<p style='color:gray;'>⚠️ فایل وجود ندارد</p>";
    }
    
    echo "<hr>";
}

// پاک کردن لاگ
if(isset($_POST['clear'])) {
    $file = $_POST['clear'];
    if(file_exists($file)) {
        file_put_contents($file, '');
        echo "<script>alert('لاگ پاک شد'); location.reload();</script>";
    }
}

echo "<h2>🔧 اقدامات</h2>";
echo "<a href='full_debug.php' style='background:#28a745;color:white;padding:10px 20px;text-decoration:none;border-radius:5px;margin:5px;display:inline-block;'>🧪 اجرای تست کامل</a>";
echo "<a href='test_bot.php' style='background:#17a2b8;color:white;padding:10px 20px;text-decoration:none;border-radius:5px;margin:5px;display:inline-block;'>📊 وضعیت ربات</a>";

echo "</body></html>";
?>
