<?php
/**
 * آپدیت دیتابیس برای سیستم مدیریت فروش پلن‌های Trading
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

include "baseInfo.php";

echo "<pre>";
echo "=== آپدیت جدول سیستم Trading ===\n\n";

$connection = new mysqli('localhost', $dbUserName, $dbPassword, $dbName);
if($connection->connect_error){
    die("❌ خطا در اتصال: " . $connection->connect_error);  
}

echo "✅ اتصال به دیتابیس موفق\n\n";
$connection->set_charset("utf8mb4");

// ساخت جدول trading_plans_status
$sql = "CREATE TABLE IF NOT EXISTS `trading_plans_status` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `plan_key` varchar(50) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `plan_key` (`plan_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci";

if($connection->query($sql)) {
    echo "✅ جدول trading_plans_status با موفقیت ساخته شد\n\n";
} else {
    echo "❌ خطا در ساخت جدول: " . $connection->error . "\n\n";
}

// درج داده‌های پیش‌فرض (همه پلن‌ها فعال)
$planKeys = ['trading1', 'trading2', 'trading3'];

foreach($planKeys as $key) {
    $stmt = $connection->prepare("INSERT IGNORE INTO `trading_plans_status` (`plan_key`, `enabled`) VALUES (?, 1)");
    $stmt->bind_param("s", $key);
    if($stmt->execute()) {
        echo "✅ پلن $key با وضعیت فعال در دیتابیس ثبت شد\n";
    }
    $stmt->close();
}

echo "\n" . str_repeat("=", 50) . "\n";
echo "🎉 آپدیت با موفقیت انجام شد!\n\n";
echo "مراحل بعدی:\n";
echo "1. به ربات بروید و /start بزنید\n";
echo "2. وارد پنل ادمین شوید\n";
echo "3. روی '📊 مدیریت فروش پلن‌های ترید' کلیک کنید\n";
echo "4. می‌توانید فروش هر پلن را فعال/غیرفعال کنید\n\n";

echo "نکات:\n";
echo "• پیش‌فرض همه پلن‌ها فعال هستند\n";
echo "• با کلیک روی هر پلن، وضعیت آن تغییر می‌کند\n";
echo "• پلن‌های غیرفعال برای کاربران نمایش داده نمی‌شوند\n";

echo "\n</pre>";
?>
