<?php
/**
 * تست ارسال فیش بانکی
 */

include_once 'config.php';

echo "<h1>🧪 تست سیستم ارسال فیش</h1>";
echo "<hr>";

// تست 1: بررسی جدول pays
echo "<h2>1️⃣ بررسی جدول pays</h2>";
$result = $connection->query("SHOW TABLES LIKE 'pays'");
if($result->num_rows > 0){
    echo "<p style='color:green;'>✅ جدول pays وجود دارد</p>";
    
    // چک ستون‌ها
    $columns = $connection->query("SHOW COLUMNS FROM pays");
    $cols = [];
    while($col = $columns->fetch_assoc()){
        $cols[] = $col['Field'];
    }
    echo "<p>ستون‌ها: " . implode(', ', $cols) . "</p>";
    
    if(in_array('photo', $cols)){
        echo "<p style='color:green;'>✅ ستون photo موجود است</p>";
    } else {
        echo "<p style='color:red;'>❌ ستون photo موجود نیست!</p>";
        echo "<p>لطفا این SQL را اجرا کنید:</p>";
        echo "<pre>ALTER TABLE `pays` ADD `photo` VARCHAR(255) NULL AFTER `state`;</pre>";
    }
} else {
    echo "<p style='color:red;'>❌ جدول pays وجود ندارد!</p>";
}

echo "<hr>";

// تست 2: بررسی جدول temp_service_purchases
echo "<h2>2️⃣ بررسی جدول temp_service_purchases</h2>";
$result = $connection->query("SHOW TABLES LIKE 'temp_service_purchases'");
if($result->num_rows > 0){
    echo "<p style='color:green;'>✅ جدول temp_service_purchases وجود دارد</p>";
} else {
    echo "<p style='color:red;'>❌ جدول temp_service_purchases وجود ندارد!</p>";
    echo "<p>فایل <a href='install_new_system.php'>install_new_system.php</a> را اجرا کنید.</p>";
}

echo "<hr>";

// تست 3: بررسی تابع RandomString
echo "<h2>3️⃣ بررسی تابع RandomString</h2>";
if(function_exists('RandomString')){
    $test_hash = RandomString();
    echo "<p style='color:green;'>✅ تابع RandomString کار می‌کند</p>";
    echo "<p>نمونه hash: <code>{$test_hash}</code></p>";
} else {
    echo "<p style='color:red;'>❌ تابع RandomString یافت نشد!</p>";
}

echo "<hr>";

// تست 4: بررسی تابع bot
echo "<h2>4️⃣ بررسی تابع bot</h2>";
if(function_exists('bot')){
    echo "<p style='color:green;'>✅ تابع bot موجود است</p>";
} else {
    echo "<p style='color:red;'>❌ تابع bot یافت نشد!</p>";
}

echo "<hr>";

// تست 5: بررسی متغیر $admin
echo "<h2>5️⃣ بررسی تنظیمات ادمین</h2>";
if(isset($admin) && $admin > 0){
    echo "<p style='color:green;'>✅ آیدی ادمین: <code>{$admin}</code></p>";
} else {
    echo "<p style='color:red;'>❌ آیدی ادمین تنظیم نشده!</p>";
}

echo "<hr>";

// تست 6: آخرین فیش‌های ارسالی
echo "<h2>6️⃣ آخرین فیش‌های ثبت شده</h2>";
$result = $connection->query("SELECT * FROM pays WHERE type='SERVICE_PLAN' ORDER BY id DESC LIMIT 5");
if($result && $result->num_rows > 0){
    echo "<table border='1' cellpadding='10' style='border-collapse:collapse; width:100%;'>";
    echo "<tr><th>ID</th><th>کاربر</th><th>مبلغ</th><th>وضعیت</th><th>Hash ID</th><th>عکس</th><th>تاریخ</th></tr>";
    while($pay = $result->fetch_assoc()){
        $amount = number_format($pay['amount'] ?? 0);
        $photo_status = !empty($pay['photo']) ? '✅ دارد' : '❌ ندارد';
        $date = $pay['date'] ?? 'نامشخص';
        echo "<tr>";
        echo "<td>{$pay['id']}</td>";
        echo "<td>{$pay['userId']}</td>";
        echo "<td>{$amount} تومان</td>";
        echo "<td>{$pay['state']}</td>";
        echo "<td><code>{$pay['hashId']}</code></td>";
        echo "<td>{$photo_status}</td>";
        echo "<td>{$date}</td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<p style='color:orange;'>⚠️ هیچ فیشی ثبت نشده</p>";
}

echo "<hr>";

// تست 7: آخرین خریدهای موقت
echo "<h2>7️⃣ آخرین خریدهای موقت</h2>";
$result = $connection->query("SELECT tsp.*, sp.name as plan_name 
                               FROM temp_service_purchases tsp 
                               LEFT JOIN service_plans sp ON tsp.plan_id = sp.id 
                               ORDER BY tsp.id DESC LIMIT 5");
if($result && $result->num_rows > 0){
    echo "<table border='1' cellpadding='10' style='border-collapse:collapse; width:100%;'>";
    echo "<tr><th>ID</th><th>کاربر</th><th>پلن</th><th>Hash ID</th></tr>";
    while($temp = $result->fetch_assoc()){
        echo "<tr>";
        echo "<td>{$temp['id']}</td>";
        echo "<td>{$temp['user_id']}</td>";
        echo "<td>{$temp['plan_name']}</td>";
        echo "<td><code>{$temp['hash_id']}</code></td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<p style='color:orange;'>⚠️ هیچ خرید موقتی وجود ندارد</p>";
}

echo "<hr>";

// خلاصه
echo "<h2>📊 نتیجه‌گیری</h2>";

$has_pays_table = $connection->query("SHOW TABLES LIKE 'pays'")->num_rows > 0;
$has_temp_table = $connection->query("SHOW TABLES LIKE 'temp_service_purchases'")->num_rows > 0;
$has_photo_column = false;
if($has_pays_table){
    $cols = $connection->query("SHOW COLUMNS FROM pays WHERE Field='photo'");
    $has_photo_column = $cols->num_rows > 0;
}

if($has_pays_table && $has_temp_table && $has_photo_column && isset($admin)){
    echo "<p style='color:green; font-size:20px;'>✅ همه چیز آماده است!</p>";
    echo "<p>حالا می‌تونید سیستم فیش بانکی رو تست کنید:</p>";
    echo "<ol>";
    echo "<li>به ربات برید</li>";
    echo "<li>خرید سرویس APN → انتخاب دسته → انتخاب پلن</li>";
    echo "<li>«پرداخت فیش بانکی» را بزنید</li>";
    echo "<li>یک عکس بفرستید</li>";
    echo "<li>باید:</li>";
    echo "<ul>";
    echo "<li>✅ پیام تایید به کاربر برسه</li>";
    echo "<li>✅ فیش به ادمین ارسال بشه</li>";
    echo "<li>✅ دکمه‌های تایید/رد نمایش داده بشه</li>";
    echo "</ul>";
    echo "</ol>";
} else {
    echo "<p style='color:red; font-size:20px;'>❌ سیستم ناقص است!</p>";
    echo "<ul>";
    if(!$has_pays_table) echo "<li>❌ جدول pays وجود ندارد</li>";
    if(!$has_photo_column) echo "<li>❌ ستون photo در جدول pays وجود ندارد</li>";
    if(!$has_temp_table) echo "<li>❌ جدول temp_service_purchases وجود ندارد</li>";
    if(!isset($admin)) echo "<li>❌ آیدی ادمین تنظیم نشده</li>";
    echo "</ul>";
}

echo "<hr>";
echo "<p style='text-align:center; color:#666;'>تاریخ: " . date('Y-m-d H:i:s') . "</p>";
?>
