<?php
/**
 * تست سیستم تایید/رد جدید
 */
include "config.php";
header('Content-Type: text/html; charset=utf-8');
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset='UTF-8'>
    <title>تست سیستم تایید/رد</title>
    <style>
        body{font-family:Tahoma; direction:rtl; background:#1a1a1a; color:#e0e0e0; padding:20px;}
        .card{background:#263238; padding:25px; margin:20px 0; border-radius:10px; border-right:5px solid #2196f3;}
        .success{border-right-color:#4caf50; background:#1b5e20;}
        .error{border-right-color:#f44336; background:#b71c1c;}
        h1{color:#64b5f6; text-align:center;}
        h2{color:#81c784; margin-top:20px;}
        pre{background:#000; padding:15px; border-radius:5px; overflow-x:auto; color:#aed581;}
        button{padding:12px 25px; background:#2196f3; color:white; border:none; border-radius:5px; cursor:pointer; margin:5px;}
        button:hover{background:#1976d2;}
        .btn-success{background:#4caf50;}
        .btn-success:hover{background:#388e3c;}
        table{width:100%; border-collapse:collapse; margin:15px 0;}
        th,td{padding:10px; border:1px solid #424242; text-align:right;}
        th{background:#37474f; color:#81c784;}
    </style>
</head>
<body>

<h1>🧪 تست سیستم تایید/رد پرداخت</h1>

<?php

echo "<div class='card'>";
echo "<h2>1️⃣ بررسی کدها</h2>";

$bot_file = file_get_contents('bot.php');

// چک کردن وجود handler های جدید
$checks = [
    'approveAuto_' => '✅ ارسال اتوماتیک',
    'approveManual_' => '📝 ارسال دستی',
    'rejectPayment_' => '❌ رد درخواست',
    'waitingManualConfig_' => '📥 دریافت کانفیگ دستی',
    'waitingRejectReason_' => '📝 دریافت دلیل رد'
];

foreach($checks as $pattern => $name){
    if(strpos($bot_file, $pattern) !== false){
        echo "<p style='color:#4caf50;'>✅ {$name} موجود است</p>";
    } else {
        echo "<p style='color:#f44336;'>❌ {$name} یافت نشد!</p>";
    }
}

echo "</div>";

// ساخت یک فیش تست
echo "<div class='card'>";
echo "<h2>2️⃣ ساخت فیش تست</h2>";

// پیدا کردن پلن
$plan_result = $connection->query("SELECT * FROM service_plans WHERE status='active' LIMIT 1");
if($plan_result && $plan_result->num_rows > 0){
    $plan = $plan_result->fetch_assoc();
    echo "<p>✅ پلن تست: {$plan['name']}</p>";
    
    // ساخت hash تست
    function makeHash(){
        return substr(md5(time() . rand()), 0, 10);
    }
    
    $hash = makeHash();
    $test_user = 8110165534; // آیدی ادمین
    $test_photo = "AgACAgTest_" . time();
    
    // ثبت در pays
    $stmt = $connection->prepare("INSERT INTO pays (user_id, hash_id, type, price, state, photo) VALUES (?, ?, 'SERVICE_PLAN', ?, 'pending', ?)");
    $stmt->bind_param("isis", $test_user, $hash, $plan['price'], $test_photo);
    $stmt->execute();
    $stmt->close();
    
    // ثبت در temp
    $stmt = $connection->prepare("INSERT INTO temp_service_purchases (hash_id, user_id, plan_id) VALUES (?, ?, ?)");
    $stmt->bind_param("sii", $hash, $test_user, $plan['id']);
    $stmt->execute();
    $stmt->close();
    
    echo "<p class='success' style='padding:15px; margin:15px 0;'>✅ فیش تست ساخته شد!</p>";
    echo "<p>🆔 Hash ID: <code>{$hash}</code></p>";
    echo "<p>👤 User ID: <code>{$test_user}</code></p>";
    echo "<p>📦 Plan ID: <code>{$plan['id']}</code></p>";
    echo "<p>💰 Price: <code>" . number_format($plan['price']) . "</code> تومان</p>";
    
    echo "<h3 style='color:#ff9800; margin-top:25px;'>🎯 حالا تست کن:</h3>";
    echo "<ol style='line-height:2; font-size:16px;'>";
    echo "<li>یه عکس تصادفی به ربات بفرست (از یه اکانت دیگه)</li>";
    echo "<li>ربات بهت میگه فیش ثبت شد</li>";
    echo "<li>به حساب ادمین ({$test_user}) عکس میاد با 3 دکمه:</li>";
    echo "<ul style='margin:10px 0 10px 30px;'>";
    echo "<li>✅ تایید و ارسال اتوماتیک</li>";
    echo "<li>📝 تایید و ارسال دستی</li>";
    echo "<li>❌ رد درخواست</li>";
    echo "</ul>";
    echo "<li>هر کدوم رو که خواستی تست کن!</li>";
    echo "</ol>";
    
    // نمایش callback data ها
    echo "<h3 style='color:#64b5f6; margin-top:25px;'>📋 Callback Data های این فیش:</h3>";
    echo "<div style='background:#000; padding:15px; border-radius:5px; margin:10px 0;'>";
    echo "<p style='color:#4caf50;'>تایید اتوماتیک: <code style='color:#fff59d;'>approveAuto_{$hash}</code></p>";
    echo "<p style='color:#2196f3;'>تایید دستی: <code style='color:#fff59d;'>approveManual_{$hash}</code></p>";
    echo "<p style='color:#f44336;'>رد درخواست: <code style='color:#fff59d;'>rejectPayment_{$hash}</code></p>";
    echo "</div>";
    
} else {
    echo "<p class='error' style='padding:15px;'>❌ پلنی یافت نشد! ابتدا پلن بسازید.</p>";
}

echo "</div>";

// لیست فیش‌های موجود
echo "<div class='card'>";
echo "<h2>3️⃣ فیش‌های در انتظار</h2>";

$pending = $connection->query("SELECT p.*, tsp.plan_id 
                                FROM pays p 
                                LEFT JOIN temp_service_purchases tsp ON p.hash_id = tsp.hash_id
                                WHERE p.state='pending' 
                                ORDER BY p.id DESC 
                                LIMIT 10");

if($pending && $pending->num_rows > 0){
    echo "<table>";
    echo "<tr><th>ID</th><th>کاربر</th><th>مبلغ</th><th>پلن</th><th>Hash ID</th><th>عملیات</th></tr>";
    while($pay = $pending->fetch_assoc()){
        echo "<tr>";
        echo "<td>{$pay['id']}</td>";
        echo "<td>{$pay['user_id']}</td>";
        echo "<td>" . number_format($pay['price']) . "</td>";
        echo "<td>{$pay['plan_id']}</td>";
        echo "<td><small>{$pay['hash_id']}</small></td>";
        echo "<td>در انتظار</td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<p>⚠️ فیش در انتظاری وجود ندارد</p>";
}

echo "</div>";

?>

<div class='card success'>
    <h2>✅ سیستم آماده است!</h2>
    <p style='font-size:18px; line-height:2;'>
        همه چیز نصب شده و آماده کار است.<br>
        حالا میتونی در ربات تست کنی!
    </p>
    
    <div style='margin-top:25px; text-align:center;'>
        <a href='PAYMENT_GUIDE.html'><button class='btn-success'>📚 مشاهده راهنما</button></a>
        <a href='CHECK_SYSTEM.php'><button>🔍 چک سیستم</button></a>
        <a href='debug_live.php'><button>📡 وضعیت زنده</button></a>
    </div>
</div>

</body>
</html>
