<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تست سیستم ارسال همگانی</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 20px;
        }
        
        .container {
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            max-width: 800px;
            width: 100%;
            padding: 40px;
        }
        
        h1 {
            color: #667eea;
            margin-bottom: 10px;
            text-align: center;
        }
        
        .subtitle {
            text-align: center;
            color: #666;
            margin-bottom: 30px;
        }
        
        .section {
            background: #f8f9fa;
            border-radius: 10px;
            padding: 20px;
            margin-bottom: 20px;
        }
        
        .section h2 {
            color: #764ba2;
            margin-bottom: 15px;
            font-size: 18px;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .status {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 15px;
            background: white;
            border-radius: 8px;
            margin-bottom: 10px;
            border-right: 4px solid #667eea;
        }
        
        .status-label {
            font-weight: bold;
            color: #333;
        }
        
        .status-value {
            color: #666;
            direction: ltr;
        }
        
        .status-value.success {
            color: #28a745;
            font-weight: bold;
        }
        
        .status-value.error {
            color: #dc3545;
            font-weight: bold;
        }
        
        .btn {
            display: inline-block;
            padding: 12px 30px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            text-decoration: none;
            border-radius: 50px;
            font-weight: bold;
            transition: all 0.3s;
            border: none;
            cursor: pointer;
            margin: 5px;
        }
        
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 20px rgba(102, 126, 234, 0.4);
        }
        
        .btn-danger {
            background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
        }
        
        .btn-success {
            background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
        }
        
        .actions {
            text-align: center;
            margin-top: 30px;
        }
        
        .alert {
            padding: 15px 20px;
            border-radius: 10px;
            margin-bottom: 20px;
        }
        
        .alert-info {
            background: #d1ecf1;
            border-right: 4px solid #0c5460;
            color: #0c5460;
        }
        
        .alert-warning {
            background: #fff3cd;
            border-right: 4px solid #856404;
            color: #856404;
        }
        
        code {
            background: #e9ecef;
            padding: 2px 8px;
            border-radius: 4px;
            font-family: 'Courier New', monospace;
        }
        
        .progress-bar {
            width: 100%;
            height: 30px;
            background: #e9ecef;
            border-radius: 15px;
            overflow: hidden;
            margin-top: 10px;
        }
        
        .progress-fill {
            height: 100%;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            transition: width 0.3s;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>📣 سیستم ارسال پیام همگانی</h1>
        <p class="subtitle">پنل تست و مدیریت</p>
        
        <?php
        error_reporting(E_ALL);
        ini_set('display_errors', 1);
        
        // چک کردن فایل تنظیمات
        $settingsFile = 'settings/messagewizwiz.json';
        $fileExists = file_exists($settingsFile);
        
        if($fileExists){
            $sendInfo = json_decode(file_get_contents($settingsFile), true);
            $offset = $sendInfo['offset'] ?? -1;
            $hasMessage = isset($sendInfo['text']) && !empty($sendInfo['text']);
            
            if($hasMessage){
                $messageData = json_decode($sendInfo['text'], true);
                $messageType = $messageData['type'] ?? 'نامشخص';
            }
        }
        
        // بررسی اتصال به دیتابیس
        $dbConnected = false;
        $totalUsers = 0;
        
        if(file_exists('baseInfo.php') && file_exists('config.php')){
            try {
                include_once 'baseInfo.php';
                include_once 'config.php';
                
                if($connection && $connection->ping()){
                    $dbConnected = true;
                    
                    $stmt = $connection->prepare("SELECT COUNT(*) as count FROM `users`");
                    $stmt->execute();
                    $totalUsers = $stmt->get_result()->fetch_assoc()['count'];
                    $stmt->close();
                }
            } catch(Exception $e) {
                $dbConnected = false;
            }
        }
        ?>
        
        <!-- وضعیت سیستم -->
        <div class="section">
            <h2>🔍 وضعیت سیستم</h2>
            
            <div class="status">
                <span class="status-label">📁 فایل تنظیمات</span>
                <span class="status-value <?= $fileExists ? 'success' : 'error' ?>">
                    <?= $fileExists ? '✅ موجود' : '❌ یافت نشد' ?>
                </span>
            </div>
            
            <div class="status">
                <span class="status-label">💾 اتصال دیتابیس</span>
                <span class="status-value <?= $dbConnected ? 'success' : 'error' ?>">
                    <?= $dbConnected ? '✅ متصل' : '❌ قطع' ?>
                </span>
            </div>
            
            <div class="status">
                <span class="status-label">👥 تعداد کل کاربران</span>
                <span class="status-value <?= $totalUsers > 0 ? 'success' : '' ?>">
                    <?= number_format($totalUsers) ?> نفر
                </span>
            </div>
        </div>
        
        <!-- وضعیت ارسال -->
        <?php if($fileExists && $hasMessage): ?>
        <div class="section">
            <h2>📊 وضعیت ارسال فعلی</h2>
            
            <div class="status">
                <span class="status-label">📝 نوع پیام</span>
                <span class="status-value"><?= $messageType ?></span>
            </div>
            
            <div class="status">
                <span class="status-label">📍 آفست (Offset)</span>
                <span class="status-value">
                    <?php 
                    if($offset == -1) echo '✅ ارسال تکمیل شده';
                    elseif($offset == 0) echo '⏸️ آماده ارسال';
                    else echo "🔄 در حال ارسال: $offset از $totalUsers";
                    ?>
                </span>
            </div>
            
            <?php if($offset > 0 && $offset < $totalUsers): ?>
            <div class="progress-bar">
                <div class="progress-fill" style="width: <?= ($offset/$totalUsers)*100 ?>%">
                    <?= round(($offset/$totalUsers)*100, 1) ?>%
                </div>
            </div>
            <?php endif; ?>
        </div>
        <?php endif; ?>
        
        <!-- هشدارها -->
        <div class="alert alert-info">
            <strong>ℹ️ نکته:</strong> برای استفاده از سیستم ارسال همگانی، به ربات تلگرام خود بروید و از منوی مدیریت استفاده کنید.
        </div>
        
        <?php if($offset > 0 && $offset < $totalUsers): ?>
        <div class="alert alert-warning">
            <strong>⚠️ توجه:</strong> یک ارسال همگانی در جریان است! برای ادامه ارسال، فایل 
            <code>send_broadcast.php</code> را اجرا کنید.
        </div>
        <?php endif; ?>
        
        <!-- اقدامات -->
        <div class="actions">
            <h2 style="margin-bottom: 20px;">🎯 اقدامات سریع</h2>
            
            <?php if($offset > 0 && $offset < $totalUsers): ?>
            <a href="send_broadcast.php?key=YOUR_SECRET_KEY_HERE" class="btn btn-success">
                ▶️ ادامه ارسال
            </a>
            <?php endif; ?>
            
            <?php if($offset >= 0): ?>
            <button onclick="resetBroadcast()" class="btn btn-danger">
                🔄 ریست کردن
            </button>
            <?php endif; ?>
            
            <a href="BROADCAST_GUIDE.md" class="btn">
                📖 مشاهده راهنما
            </a>
            
            <a href="check_all.php" class="btn">
                🔍 بررسی فایل‌ها
            </a>
        </div>
        
        <!-- راهنمای سریع -->
        <div class="section" style="margin-top: 30px;">
            <h2>🚀 راهنمای سریع</h2>
            <ol style="padding-right: 20px; line-height: 2;">
                <li>وارد ربات تلگرام شوید</li>
                <li>از منوی "مدیریت ربات" وارد شوید</li>
                <li>دکمه "ارسال پیام همگانی" را بزنید</li>
                <li>پیام خود را ارسال کنید</li>
                <li>پس از تأیید، ارسال آغاز می‌شود</li>
            </ol>
        </div>
    </div>
    
    <script>
        function resetBroadcast() {
            if(confirm('آیا مطمئن هستید که می‌خواهید ارسال را ریست کنید؟')) {
                fetch('reset_broadcast.php')
                    .then(response => response.json())
                    .then(data => {
                        if(data.success) {
                            alert('✅ ریست با موفقیت انجام شد!');
                            location.reload();
                        } else {
                            alert('❌ خطا در ریست: ' + data.message);
                        }
                    })
                    .catch(error => {
                        alert('❌ خطا در ارتباط با سرور');
                    });
            }
        }
    </script>
</body>
</html>
