<?php
// فایل تست ربات
include_once 'baseInfo.php';

echo "<h2>🔍 تست کامل ربات</h2>";
echo "<hr>";

// 1. تست اتصال به API تلگرام
echo "<h3>1️⃣ تست اتصال به API تلگرام</h3>";
$url = "https://api.telegram.org/bot" . $botToken . "/getMe";
$response = file_get_contents($url);
$data = json_decode($response, true);

if($data['ok']) {
    echo "✅ اتصال به API تلگرام موفق<br>";
    echo "نام ربات: " . $data['result']['first_name'] . "<br>";
    echo "یوزرنیم: @" . $data['result']['username'] . "<br>";
} else {
    echo "❌ خطا در اتصال به API<br>";
}
echo "<hr>";

// 2. تست اتصال به دیتابیس
echo "<h3>2️⃣ تست اتصال به دیتابیس</h3>";
$connection = new mysqli('localhost', $dbUserName, $dbPassword, $dbName);
if($connection->connect_error) {
    echo "❌ خطا در اتصال به دیتابیس: " . $connection->connect_error . "<br>";
} else {
    echo "✅ اتصال به دیتابیس موفق<br>";
    
    // تست جدول users
    $result = $connection->query("SHOW TABLES LIKE 'users'");
    if($result->num_rows > 0) {
        echo "✅ جدول users وجود دارد<br>";
        
        // تعداد کاربران
        $count = $connection->query("SELECT COUNT(*) as cnt FROM users")->fetch_assoc();
        echo "👥 تعداد کاربران: " . $count['cnt'] . "<br>";
    } else {
        echo "❌ جدول users وجود ندارد<br>";
    }
}
echo "<hr>";

// 3. تست Webhook
echo "<h3>3️⃣ وضعیت Webhook</h3>";
$url = "https://api.telegram.org/bot" . $botToken . "/getWebhookInfo";
$response = file_get_contents($url);
$webhookInfo = json_decode($response, true);

if($webhookInfo['ok']) {
    $info = $webhookInfo['result'];
    echo "آدرس Webhook: " . ($info['url'] ?? 'تنظیم نشده') . "<br>";
    echo "آخرین آپدیت: " . ($info['last_error_date'] ?? 'ندارد') . "<br>";
    echo "آخرین خطا: " . ($info['last_error_message'] ?? 'ندارد') . "<br>";
    echo "تعداد آپدیت‌های منتظر: " . ($info['pending_update_count'] ?? '0') . "<br>";
    
    if(empty($info['url'])) {
        echo "<br><a href='setWebhook.php' style='color:red; font-weight:bold;'>⚠️ Webhook تنظیم نشده! کلیک کنید</a><br>";
    } else if($info['url'] != $botUrl . "bot.php") {
        echo "<br><span style='color:orange;'>⚠️ آدرس Webhook متفاوت است</span><br>";
        echo "آدرس فعلی: " . $info['url'] . "<br>";
        echo "آدرس صحیح: " . $botUrl . "bot.php<br>";
        echo "<a href='setWebhook.php' style='color:red; font-weight:bold;'>کلیک کنید برای تنظیم مجدد</a><br>";
    } else {
        echo "<br>✅ Webhook صحیح تنظیم شده<br>";
    }
}
echo "<hr>";

// 4. تست ارسال پیام
echo "<h3>4️⃣ تست ارسال پیام</h3>";
echo "<form method='post'>";
echo "آیدی عددی: <input type='text' name='test_chat_id' value='$admin'><br>";
echo "<button type='submit' name='send_test'>ارسال پیام تست</button>";
echo "</form>";

if(isset($_POST['send_test'])) {
    $test_chat_id = $_POST['test_chat_id'];
    $url = "https://api.telegram.org/bot" . $botToken . "/sendMessage";
    $post = [
        'chat_id' => $test_chat_id,
        'text' => "🧪 این یک پیام تست است\n\n✅ ربات کار می‌کند!"
    ];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
    $result = curl_exec($ch);
    curl_close($ch);
    
    $res = json_decode($result, true);
    if($res['ok']) {
        echo "<br>✅ پیام با موفقیت ارسال شد<br>";
    } else {
        echo "<br>❌ خطا در ارسال پیام: " . $res['description'] . "<br>";
    }
}
echo "<hr>";

// 5. تست فایل‌های اصلی
echo "<h3>5️⃣ وضعیت فایل‌های اصلی</h3>";
$files = [
    'bot.php',
    'config.php',
    'baseInfo.php',
    'settings/values.php',
    'server_manager.php',
    'service_creator.php'
];

foreach($files as $file) {
    if(file_exists($file)) {
        echo "✅ " . $file . "<br>";
    } else {
        echo "❌ " . $file . " وجود ندارد<br>";
    }
}

echo "<hr>";
echo "<h3>📋 نتیجه</h3>";
echo "<p>حالا در تلگرام به ربات پیام <code>/start</code> بدهید</p>";
echo "<p>اگر ربات جواب نداد، لاگ خطاها را بررسی کنید</p>";
?>
