<?php
// نمایش خطاهای واقعی bot.php
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('log_errors', 1);
ini_set('error_log', 'bot_errors.txt');

echo "شروع تست...\n\n";

// شبیه‌سازی ورودی از تلگرام
$update = json_encode([
    'update_id' => 123456789,
    'message' => [
        'message_id' => 1,
        'from' => [
            'id' => 8110165534,
            'is_bot' => false,
            'first_name' => 'تست',
            'username' => 'test',
            'language_code' => 'fa'
        ],
        'chat' => [
            'id' => 8110165534,
            'first_name' => 'تست',
            'username' => 'test',
            'type' => 'private'
        ],
        'date' => time(),
        'text' => '/start'
    ]
]);

// قرار دادن ورودی
$_POST['update'] = $update;
file_put_contents('php://input', $update);

echo "ورودی آماده شد...\n";

// اجرای bot.php
try {
    echo "در حال اجرای bot.php...\n\n";
    include 'bot.php';
    echo "\n\n✅ اجرا موفق بود!\n";
} catch (Throwable $e) {
    echo "\n\n❌ خطا رخ داد:\n";
    echo "پیام: " . $e->getMessage() . "\n";
    echo "فایل: " . $e->getFile() . "\n";
    echo "خط: " . $e->getLine() . "\n";
    echo "\nStack Trace:\n";
    echo $e->getTraceAsString() . "\n";
}

echo "\n\nبررسی لاگ خطاها:\n";
if(file_exists('bot_errors.txt')) {
    echo file_get_contents('bot_errors.txt');
} else {
    echo "لاگ خطا وجود ندارد\n";
}
?>
