<?php
/**
 * سیستم نوتیفیکیشن هوشمند
 * اعلان‌های خودکار برای کاربران
 */

include_once 'config.php';

/**
 * چک کردن سرویس‌های در حال اتمام
 * باید هر 6 ساعت یکبار اجرا شود (Cron Job)
 */
function checkExpiringServices() {
    global $connection;
    
    $now = time();
    $seven_days = $now + (7 * 24 * 60 * 60);
    $three_days = $now + (3 * 24 * 60 * 60);
    $one_day = $now + (1 * 24 * 60 * 60);
    
    // کاربرانی که 7 روز به اتمام سرویسشان مانده
    $stmt = $connection->prepare("
        SELECT o.*, u.userid, u.name 
        FROM `orders_list` o
        JOIN `users` u ON o.userid = u.userid
        WHERE o.status = 1 
        AND o.notif = 0
        AND o.expire_date > ? 
        AND o.expire_date <= ?
    ");
    $stmt->bind_param("ii", $now, $seven_days);
    $stmt->execute();
    $result = $stmt->get_result();
    
    while($order = $result->fetch_assoc()) {
        $days_left = ceil(($order['expire_date'] - $now) / 86400);
        
        $message = "⏰ یادآوری اتمام سرویس

🔔 سرویس شما <b>$days_left روز</b> دیگر به پایان می‌رسد!

📦 نام سرویس: {$order['remark']}
📅 تاریخ انقضا: " . jdate('Y/m/d', $order['expire_date']) . "

💡 برای تمدید یا خرید سرویس جدید، از منوی اصلی اقدام کنید.

🚪 /start";

        sendMessage($message, json_encode([
            'inline_keyboard' => [
                [['text' => '🔄 تمدید سرویس', 'callback_data' => 'renewService_' . $order['id']]],
                [['text' => '🛍 خرید جدید', 'callback_data' => 'buy_subscriptions']],
                [['text' => '📞 پشتیبانی', 'callback_data' => 'supportSection']]
            ]
        ]), 'HTML', $order['userid']);
        
        // علامت‌گذاری که نوتیفیکیشن ارسال شده
        $update_notif = $connection->prepare("UPDATE `orders_list` SET `notif` = ? WHERE `id` = ?");
        $notif_value = $days_left;
        $update_notif->bind_param("ii", $notif_value, $order['id']);
        $update_notif->execute();
        $update_notif->close();
        
        sleep(1); // جلوگیری از اسپم
    }
    $stmt->close();
    
    return "✅ چک نوتیفیکیشن انجام شد";
}

/**
 * چک کردن سرویس‌های منقضی شده
 */
function checkExpiredServices() {
    global $connection;
    
    $now = time();
    
    $stmt = $connection->prepare("
        SELECT o.*, u.userid, u.name 
        FROM `orders_list` o
        JOIN `users` u ON o.userid = u.userid
        WHERE o.status = 1 
        AND o.expire_date < ?
        AND o.expire_date > ?
    ");
    $yesterday = $now - 86400;
    $stmt->bind_param("ii", $now, $yesterday);
    $stmt->execute();
    $result = $stmt->get_result();
    
    while($order = $result->fetch_assoc()) {
        $message = "⚠️ سرویس شما منقضی شد!

📦 نام سرویس: {$order['remark']}
📅 تاریخ انقضا: " . jdate('Y/m/d', $order['expire_date']) . "

💡 برای ادامه استفاده، یک سرویس جدید خریداری کنید یا سرویس فعلی را تمدید نمایید.

🎁 کاربران وفادار ما از تخفیف ویژه برخوردارند!

🚪 /start";

        sendMessage($message, json_encode([
            'inline_keyboard' => [
                [['text' => '🛍 خرید سرویس جدید', 'callback_data' => 'buy_subscriptions']],
                [['text' => '🔥 مشاهده تخفیف‌ها', 'callback_data' => 'vipPlans']],
                [['text' => '📞 پشتیبانی', 'callback_data' => 'supportSection']]
            ]
        ]), 'HTML', $order['userid']);
        
        // غیرفعال کردن سرویس
        $update_status = $connection->prepare("UPDATE `orders_list` SET `status` = 0 WHERE `id` = ?");
        $update_status->bind_param("i", $order['id']);
        $update_status->execute();
        $update_status->close();
        
        sleep(1);
    }
    $stmt->close();
    
    return "✅ چک سرویس‌های منقضی شده انجام شد";
}

/**
 * پیام خوشامدگویی برای کاربران جدید
 */
function sendWelcomeMessage($user_id, $first_name) {
    $message = "🎉 به فروشگاه تحریم‌شکن APN خوش آمدید!

سلام <b>$first_name</b> عزیز 👋

ما بهترین سرویس‌های VPN را با قیمت مناسب و کیفیت عالی ارائه می‌دهیم.

🌟 چرا ما را انتخاب کنید؟
━━━━━━━━━━━━━━━━━━━━━━

⚡️ سرعت بالا و پایدار
🔒 امنیت کامل
🌍 سرورهای متنوع
💎 پشتیبانی 24/7
✅ ضمانت بازگشت وجه

━━━━━━━━━━━━━━━━━━━━━━

🎁 <b>پیشنهاد ویژه برای شما:</b>
اولین خرید خود را با <b>10% تخفیف</b> انجام دهید!
کد تخفیف: <code>WELCOME10</code>

📱 از منوی زیر شروع کنید 👇";

    return sendMessage($message, getMainKeys(), 'HTML', $user_id);
}

/**
 * ارسال نوتیفیکیشن موفقیت خرید
 */
function sendPurchaseSuccessNotification($user_id, $plan_name, $volume, $days, $price) {
    $message = "🎊 خرید شما با موفقیت انجام شد!

━━━━━━━━━━━━━━━━━━━━━━
🎉 تبریک! شما الان عضو خانواده APN هستید
━━━━━━━━━━━━━━━━━━━━━━

📦 پلن: <b>$plan_name</b>
🔋 حجم: <b>$volume</b>
⏰ مدت: <b>$days روز</b>
💰 مبلغ پرداختی: <b>" . number_format($price) . " تومان</b>

━━━━━━━━━━━━━━━━━━━━━━

💡 <b>نکات مهم:</b>

1️⃣ کانفیگ شما در بخش 'سرویس‌های من' ذخیره شده
2️⃣ QR Code را اسکن کنید یا لینک را کپی کنید
3️⃣ اپلیکیشن مناسب را نصب کنید
4️⃣ از اینترنت آزاد لذت ببرید!

📱 اگر نیاز به راهنمایی دارید، روی دکمه زیر کلیک کنید 👇";

    return sendMessage($message, json_encode([
        'inline_keyboard' => [
            [['text' => '📋 سرویس‌های من', 'callback_data' => 'myOrders']],
            [['text' => '🧩 آموزش اتصال', 'callback_data' => 'howToConnect']],
            [['text' => '📞 پشتیبانی', 'callback_data' => 'supportSection']]
        ]
    ]), 'HTML', $user_id);
}

// اگر مستقیم اجرا شود (Cron Job)
if (php_sapi_name() === 'cli' || isset($_GET['cron'])) {
    echo "🤖 شروع چک نوتیفیکیشن‌ها...\n\n";
    echo checkExpiringServices() . "\n";
    echo checkExpiredServices() . "\n";
    echo "\n✅ تمام!";
}
?>
