<?php
// نمایش تمام خطاها
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/php_errors.log');

echo "<pre>";
echo "🔍 دیباگ کامل ربات\n";
echo "====================\n\n";

// شبیه‌سازی دقیق ورودی تلگرام
$update = [
    'update_id' => 718779344,
    'message' => [
        'message_id' => 999,
        'from' => [
            'id' => 8110165534,
            'is_bot' => false,
            'first_name' => 'تست',
            'username' => 'test'
        ],
        'chat' => [
            'id' => 8110165534,
            'first_name' => 'تست',
            'type' => 'private'
        ],
        'date' => time(),
        'text' => '/start'
    ]
];

// ذخیره به عنوان input
$GLOBALS['HTTP_RAW_POST_DATA'] = json_encode($update);

echo "1️⃣ تست فایل config.php\n";
echo "------------------------\n";
ob_start();
try {
    include_once 'baseInfo.php';
    echo "✅ baseInfo.php لود شد\n";
} catch (Throwable $e) {
    ob_end_clean();
    echo "❌ خطا در baseInfo.php:\n";
    echo $e->getMessage() . "\n";
    echo $e->getFile() . ":" . $e->getLine() . "\n";
    exit;
}
ob_end_clean();

echo "\n2️⃣ تست فایل config.php\n";
echo "------------------------\n";
ob_start();
try {
    // شبیه‌سازی ورودی برای config.php
    file_put_contents('php://input', json_encode($update));
    
    include_once 'settings/values.php';
    echo "✅ values.php لود شد\n";
    
    include_once 'config.php';
    echo "✅ config.php لود شد\n";
    
    // بررسی متغیرهای مهم
    if(isset($from_id)) {
        echo "✅ \$from_id = $from_id\n";
    } else {
        echo "❌ \$from_id تعریف نشده\n";
    }
    
    if(isset($text)) {
        echo "✅ \$text = $text\n";
    } else {
        echo "❌ \$text تعریف نشده\n";
    }
    
    if(isset($userInfo)) {
        echo "✅ \$userInfo موجود است\n";
    } else {
        echo "⚠️ \$userInfo موجود نیست (کاربر جدید)\n";
    }
    
} catch (Throwable $e) {
    ob_end_clean();
    echo "❌ خطا:\n";
    echo "پیام: " . $e->getMessage() . "\n";
    echo "فایل: " . $e->getFile() . "\n";
    echo "خط: " . $e->getLine() . "\n";
    echo "\nStack:\n" . $e->getTraceAsString() . "\n";
    exit;
}
$output = ob_get_clean();
echo $output;

echo "\n3️⃣ تست فایل‌های دیگر\n";
echo "------------------------\n";
$files = [
    'server_manager.php',
    'service_creator.php', 
    'trading_plans_handler.php',
    'notification_system.php',
    'discount_system.php',
    'advanced_reports.php'
];

foreach($files as $file) {
    ob_start();
    try {
        include_once $file;
        ob_end_clean();
        echo "✅ $file\n";
    } catch (Throwable $e) {
        ob_end_clean();
        echo "❌ $file: " . $e->getMessage() . "\n";
    }
}

echo "\n4️⃣ اجرای کد ربات\n";
echo "------------------------\n";

// ریست کردن برای تست واقعی
foreach (get_included_files() as $file) {
    if(basename($file) == 'bot.php') {
        echo "⚠️ bot.php قبلاً لود شده\n";
    }
}

ob_start();
try {
    // شبیه‌سازی دقیق
    $_SERVER['REQUEST_METHOD'] = 'POST';
    
    include 'bot.php';
    
    $bot_output = ob_get_clean();
    echo "✅ bot.php اجرا شد\n";
    
    if(!empty($bot_output)) {
        echo "\nخروجی bot.php:\n";
        echo "---\n";
        echo $bot_output;
        echo "\n---\n";
    }
    
} catch (Throwable $e) {
    ob_end_clean();
    echo "❌ خطا در bot.php:\n";
    echo "پیام: " . $e->getMessage() . "\n";
    echo "فایل: " . $e->getFile() . "\n";
    echo "خط: " . $e->getLine() . "\n";
    echo "\nStack Trace:\n";
    echo $e->getTraceAsString() . "\n";
}

echo "\n5️⃣ بررسی لاگ خطاها\n";
echo "------------------------\n";
if(file_exists('php_errors.log')) {
    $errors = file_get_contents('php_errors.log');
    if(!empty($errors)) {
        echo $errors . "\n";
    } else {
        echo "✅ لاگ خالی است\n";
    }
}

if(file_exists('settings/error_log')) {
    echo "\nخطاهای قبلی:\n";
    $old_errors = file_get_contents('settings/error_log');
    $lines = explode("\n", $old_errors);
    $last_lines = array_slice($lines, -20);
    echo implode("\n", $last_lines);
}

echo "\n\n====================\n";
echo "✅ تست کامل شد\n";
echo "</pre>";
?>
