<?php
include_once 'baseInfo.php';

echo "<html><head><meta charset='utf-8'></head><body>";
echo "<h1>🔧 رفع مشکل ربات</h1>";
echo "<hr>";

// مرحله 1: حذف webhook
echo "<h2>مرحله 1: حذف Webhook قبلی</h2>";
$url = "https://api.telegram.org/bot" . $botToken . "/deleteWebhook";
$response = file_get_contents($url);
$data = json_decode($response, true);
if($data['ok']) {
    echo "✅ Webhook قبلی حذف شد<br>";
} else {
    echo "❌ خطا در حذف webhook<br>";
}
echo "<hr>";

// مرحله 2: دریافت آپدیت‌های معلق
echo "<h2>مرحله 2: پاک کردن آپدیت‌های معلق</h2>";
$url = "https://api.telegram.org/bot" . $botToken . "/getUpdates?offset=-1";
$response = file_get_contents($url);
$data = json_decode($response, true);
if($data['ok'] && !empty($data['result'])) {
    $lastUpdateId = $data['result'][0]['update_id'];
    // پاک کردن با offset
    $url2 = "https://api.telegram.org/bot" . $botToken . "/getUpdates?offset=" . ($lastUpdateId + 1);
    file_get_contents($url2);
    echo "✅ آپدیت‌های معلق پاک شدند (تعداد: " . count($data['result']) . ")<br>";
} else {
    echo "✅ آپدیت معلقی وجود ندارد<br>";
}
echo "<hr>";

// مرحله 3: تنظیم webhook جدید
echo "<h2>مرحله 3: تنظیم Webhook جدید</h2>";
$webhook_url = $botUrl . "bot.php";
$url = "https://api.telegram.org/bot" . $botToken . "/setWebhook?url=" . urlencode($webhook_url);
$response = file_get_contents($url);
$data = json_decode($response, true);

if($data['ok']) {
    echo "✅ Webhook با موفقیت تنظیم شد<br>";
    echo "آدرس: <code>$webhook_url</code><br>";
} else {
    echo "❌ خطا در تنظیم webhook<br>";
    echo "پاسخ: <pre>" . print_r($data, true) . "</pre>";
}
echo "<hr>";

// مرحله 4: تست ارسال پیام
echo "<h2>مرحله 4: تست ارسال پیام به ادمین</h2>";
$testUrl = "https://api.telegram.org/bot" . $botToken . "/sendMessage";
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $testUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, [
    'chat_id' => $admin,
    'text' => "🔧 ربات راه‌اندازی شد!\n\n✅ حالا /start را تست کنید",
    'parse_mode' => 'HTML'
]);
$result = curl_exec($ch);
curl_close($ch);
$testData = json_decode($result, true);

if($testData['ok']) {
    echo "✅ پیام تست به ادمین ارسال شد<br>";
} else {
    echo "❌ خطا در ارسال پیام: " . ($testData['description'] ?? 'نامشخص') . "<br>";
}
echo "<hr>";

// نتیجه نهایی
echo "<h2>✅ تمام مراحل انجام شد</h2>";
echo "<p><strong>حالا این کارها را انجام دهید:</strong></p>";
echo "<ol>";
echo "<li>در تلگرام به ربات بروید</li>";
echo "<li>دستور <code>/start</code> را ارسال کنید</li>";
echo "<li>اگر جواب نداد، <a href='debug_webhook.php'>debug_webhook.php</a> را به عنوان webhook تنظیم کنید و لاگ‌ها را بررسی کنید</li>";
echo "</ol>";

echo "<hr>";
echo "<p><a href='test_bot.php'>🔍 مشاهده وضعیت کامل ربات</a></p>";
echo "</body></html>";
?>
