<?php
/**
 * فایل دیباگ ربات - برای پیدا کردن مشکلات
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h1>🔍 دیباگ ربات APN</h1>";
echo "<hr>";

// 1. چک کردن فایل‌های اصلی
echo "<h2>1️⃣ چک فایل‌های اصلی</h2>";

$required_files = [
    'baseInfo.php',
    'config.php',
    'bot.php',
    'vip_plans_handler.php',
    'notification_system.php',
    'discount_system.php',
    'advanced_reports.php',
    'trading_plans_handler.php'
];

$missing_files = [];
foreach($required_files as $file) {
    if(file_exists($file)) {
        echo "✅ $file<br>";
    } else {
        echo "❌ $file <strong>یافت نشد!</strong><br>";
        $missing_files[] = $file;
    }
}

if(count($missing_files) > 0) {
    echo "<p style='color:red;'><strong>⚠️ فایل‌های زیر وجود ندارند:</strong><br>";
    foreach($missing_files as $file) {
        echo "- $file<br>";
    }
    echo "</p>";
}

echo "<hr>";

// 2. چک کردن baseInfo.php
echo "<h2>2️⃣ چک اطلاعات دیتابیس</h2>";

if(file_exists('baseInfo.php')) {
    include_once 'baseInfo.php';
    
    echo "✅ فایل baseInfo.php لود شد<br>";
    echo "📌 نام دیتابیس: " . (isset($dbName) ? $dbName : '❌ تعریف نشده') . "<br>";
    echo "📌 نام کاربری: " . (isset($dbUserName) ? $dbUserName : '❌ تعریف نشده') . "<br>";
    echo "📌 توکن ربات: " . (isset($botToken) ? substr($botToken, 0, 10) . '...' : '❌ تعریف نشده') . "<br>";
    echo "📌 آیدی ادمین: " . (isset($admin) ? $admin : '❌ تعریف نشده') . "<br>";
} else {
    echo "❌ فایل baseInfo.php یافت نشد!<br>";
}

echo "<hr>";

// 3. تست اتصال به دیتابیس
echo "<h2>3️⃣ تست اتصال دیتابیس</h2>";

if(isset($dbUserName) && isset($dbPassword) && isset($dbName)) {
    $connection = new mysqli('localhost', $dbUserName, $dbPassword, $dbName);
    
    if($connection->connect_error) {
        echo "❌ <strong>خطا در اتصال به دیتابیس:</strong><br>";
        echo "<code>" . $connection->connect_error . "</code><br>";
        echo "<p style='background:#fff3cd; padding:10px;'>💡 <strong>راه حل:</strong> اطلاعات دیتابیس در baseInfo.php را چک کنید</p>";
    } else {
        echo "✅ اتصال به دیتابیس موفق بود<br>";
        
        // چک جداول مهم
        echo "<br><strong>چک جداول:</strong><br>";
        $tables = ['users', 'pays', 'discounts', 'orders_list', 'server_plans'];
        
        foreach($tables as $table) {
            $result = $connection->query("SHOW TABLES LIKE '$table'");
            if($result && $result->num_rows > 0) {
                echo "✅ جدول <code>$table</code> وجود دارد<br>";
            } else {
                echo "❌ جدول <code>$table</code> وجود ندارد<br>";
            }
        }
        
        $connection->close();
    }
} else {
    echo "❌ اطلاعات دیتابیس تعریف نشده!<br>";
}

echo "<hr>";

// 4. چک Webhook
echo "<h2>4️⃣ چک Webhook</h2>";

if(isset($botToken)) {
    $webhook_url = "https://api.telegram.org/bot{$botToken}/getWebhookInfo";
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $webhook_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    $response = curl_exec($ch);
    curl_close($ch);
    
    if($response) {
        $webhook_info = json_decode($response, true);
        
        if(isset($webhook_info['result'])) {
            $url = $webhook_info['result']['url'] ?? 'تنظیم نشده';
            $pending = $webhook_info['result']['pending_update_count'] ?? 0;
            $last_error = $webhook_info['result']['last_error_message'] ?? 'خطایی نیست';
            
            echo "📍 URL Webhook: <code>" . ($url ?: 'تنظیم نشده') . "</code><br>";
            echo "📊 آپدیت‌های در انتظار: <strong>$pending</strong><br>";
            
            if($last_error != 'خطایی نیست') {
                echo "⚠️ <strong>آخرین خطا:</strong> <code style='color:red;'>$last_error</code><br>";
            } else {
                echo "✅ خطایی وجود ندارد<br>";
            }
            
            // بررسی URL صحیح
            $current_domain = $_SERVER['HTTP_HOST'];
            $expected_url = "https://$current_domain/bot.php";
            
            if($url != $expected_url && $url != '') {
                echo "<p style='background:#fff3cd; padding:10px;'>⚠️ <strong>توجه:</strong> آدرس Webhook شما:<br>";
                echo "<code>$url</code><br>";
                echo "باید باشد:<br>";
                echo "<code>$expected_url</code><br>";
                echo "<a href='setWebhook.php' style='display:inline-block; margin-top:10px; padding:8px 16px; background:#007bff; color:white; text-decoration:none; border-radius:5px;'>🔧 تنظیم مجدد Webhook</a>";
                echo "</p>";
            } elseif($url == '') {
                echo "<p style='background:#f8d7da; padding:10px;'>❌ <strong>Webhook تنظیم نشده!</strong><br>";
                echo "<a href='setWebhook.php' style='display:inline-block; margin-top:10px; padding:8px 16px; background:#dc3545; color:white; text-decoration:none; border-radius:5px;'>🔧 تنظیم Webhook</a>";
                echo "</p>";
            } else {
                echo "✅ آدرس Webhook صحیح است<br>";
            }
            
        }
    }
} else {
    echo "❌ توکن ربات تعریف نشده!<br>";
}

echo "<hr>";

// 5. چک خطاهای PHP
echo "<h2>5️⃣ چک خطاهای PHP</h2>";

$error_log = 'error_log';
if(file_exists($error_log)) {
    echo "⚠️ فایل error_log وجود دارد<br>";
    $errors = file($error_log);
    $last_errors = array_slice($errors, -10);
    
    echo "<strong>10 خطای آخر:</strong><br>";
    echo "<pre style='background:#f8f9fa; padding:10px; overflow:auto; max-height:200px;'>";
    foreach($last_errors as $error) {
        echo htmlspecialchars($error);
    }
    echo "</pre>";
} else {
    echo "✅ فایل error_log وجود ندارد (یعنی خطایی نبوده)<br>";
}

echo "<hr>";

// 6. تست include کردن فایل‌ها
echo "<h2>6️⃣ تست include فایل‌ها</h2>";

$test_files = [
    'config.php',
    'vip_plans_handler.php',
    'notification_system.php',
    'discount_system.php',
    'advanced_reports.php',
    'trading_plans_handler.php'
];

foreach($test_files as $file) {
    if(file_exists($file)) {
        try {
            include_once $file;
            echo "✅ $file - لود شد<br>";
        } catch(Exception $e) {
            echo "❌ $file - <strong>خطا:</strong> " . $e->getMessage() . "<br>";
        }
    } else {
        echo "⚠️ $file - فایل وجود ندارد<br>";
    }
}

echo "<hr>";

// 7. مجوزهای فایل
echo "<h2>7️⃣ چک مجوزهای فایل‌ها</h2>";

$check_permissions = ['bot.php', 'config.php', 'baseInfo.php'];

foreach($check_permissions as $file) {
    if(file_exists($file)) {
        $perms = substr(sprintf('%o', fileperms($file)), -4);
        echo "📄 $file: <code>$perms</code> ";
        
        if(is_readable($file)) {
            echo "✅ قابل خواندن<br>";
        } else {
            echo "❌ غیر قابل خواندن!<br>";
        }
    }
}

echo "<hr>";

// خلاصه و راهنمایی
echo "<h2>📋 خلاصه و راهنمایی</h2>";

$issues = [];

if(count($missing_files) > 0) {
    $issues[] = "فایل‌هایی وجود ندارند - آپلود کنید";
}

if(isset($connection) && $connection->connect_error) {
    $issues[] = "مشکل در اتصال دیتابیس - baseInfo.php را چک کنید";
}

if(isset($url) && $url == '') {
    $issues[] = "Webhook تنظیم نشده - setWebhook.php را اجرا کنید";
}

if(count($issues) > 0) {
    echo "<div style='background:#f8d7da; padding:15px; border-left:4px solid #dc3545;'>";
    echo "<strong>❌ مشکلات پیدا شده:</strong><br><br>";
    foreach($issues as $i => $issue) {
        echo ($i + 1) . ". $issue<br>";
    }
    echo "</div>";
} else {
    echo "<div style='background:#d4edda; padding:15px; border-left:4px solid #28a745;'>";
    echo "<strong>✅ همه چیز اوکی به نظر میاد!</strong><br>";
    echo "اگر ربات هنوز کار نمی‌کنه:<br>";
    echo "1. Webhook رو دوباره تنظیم کنید: <a href='setWebhook.php'>setWebhook.php</a><br>";
    echo "2. به ربات تلگرام /start بزنید<br>";
    echo "3. اگر باز کار نکرد، فایل error_log رو بررسی کنید<br>";
    echo "</div>";
}

echo "<hr>";
echo "<p style='text-align:center; color:#666;'>🤖 APN Bot Debug Tool - Version 1.0</p>";
?>
