-- جدول ذخیره اکانت‌های VIP ساخته شده

CREATE TABLE IF NOT EXISTS `vip_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL COMMENT 'شناسه کاربر تلگرام',
  `hash_id` varchar(100) NOT NULL COMMENT 'شناسه تراکنش از جدول pays',
  `plan_id` varchar(50) NOT NULL COMMENT 'شناسه پلن (مثل vip1, vip2)',
  `email` varchar(255) NOT NULL COMMENT 'نام اکانت در پنل',
  `uuid` varchar(100) NOT NULL COMMENT 'UUID اکانت',
  `inbound_id` int(11) NOT NULL COMMENT 'شناسه Inbound در پنل',
  `volume_gb` int(11) NOT NULL DEFAULT 0 COMMENT 'حجم به گیگابایت (0=نامحدود)',
  `days` int(11) NOT NULL COMMENT 'تعداد روزهای اعتبار',
  `vless_link` text DEFAULT NULL COMMENT 'لینک VLESS',
  `expire_date` int(11) NOT NULL COMMENT 'تاریخ انقضا (timestamp)',
  `created_at` int(11) NOT NULL COMMENT 'تاریخ ساخت (timestamp)',
  `status` enum('active','expired','deleted','suspended') DEFAULT 'active',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `hash_id` (`hash_id`),
  KEY `email` (`email`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='اکانت‌های VIP ساخته شده';

-- جدول لاگ عملیات روی اکانت‌ها
CREATE TABLE IF NOT EXISTS `vip_account_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_id` int(11) NOT NULL COMMENT 'شناسه اکانت از جدول vip_accounts',
  `action` varchar(50) NOT NULL COMMENT 'نوع عملیات: created, renewed, deleted, suspended',
  `description` text DEFAULT NULL COMMENT 'توضیحات',
  `created_at` int(11) NOT NULL COMMENT 'زمان عملیات',
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `action` (`action`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='لاگ عملیات روی اکانت‌ها';
