<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h1>🔍 بررسی جامع ربات</h1><hr>";

// 1. بررسی Syntax
echo "<h2>1️⃣ بررسی Syntax فایل‌ها</h2>";

$files = [
    'bot.php',
    'config.php',
    'vip_plans_handler.php',
    'notification_system.php',
    'discount_system.php',
    'advanced_reports.php',
    'trading_plans_handler.php'
];

$syntax_errors = [];

foreach($files as $file) {
    if(!file_exists($file)) {
        echo "❌ <b>$file</b> - فایل وجود ندارد!<br>";
        $syntax_errors[] = $file;
        continue;
    }
    
    // چک syntax با PHP linter
    $output = shell_exec("php -l \"$file\" 2>&1");
    
    if(strpos($output, 'No syntax errors') !== false) {
        echo "✅ <b>$file</b> - OK<br>";
    } else {
        echo "❌ <b>$file</b> - خطای Syntax!<br>";
        echo "<pre style='background:#f8d7da;padding:10px;margin:5px 0;'>$output</pre>";
        $syntax_errors[] = $file;
    }
}

echo "<br><hr>";

// 2. اگر syntax درست بود، تست Include
if(empty($syntax_errors)) {
    echo "<h2>2️⃣ تست Include فایل‌ها</h2>";
    
    try {
        ob_start();
        include_once 'baseInfo.php';
        echo "✅ baseInfo.php<br>";
        
        include_once 'config.php';
        echo "✅ config.php<br>";
        
        include_once 'vip_plans_handler.php';
        echo "✅ vip_plans_handler.php<br>";
        
        include_once 'notification_system.php';
        echo "✅ notification_system.php<br>";
        
        include_once 'discount_system.php';
        echo "✅ discount_system.php<br>";
        
        include_once 'advanced_reports.php';
        echo "✅ advanced_reports.php<br>";
        
        include_once 'trading_plans_handler.php';
        echo "✅ trading_plans_handler.php<br>";
        
        ob_end_clean();
        
        echo "<br><div style='background:#d4edda;padding:15px;border-left:4px solid #28a745;'>";
        echo "✅ <b>همه فایل‌ها بدون خطا لود شدند!</b>";
        echo "</div>";
        
    } catch(Exception $e) {
        ob_end_clean();
        echo "<div style='background:#f8d7da;padding:15px;border-left:4px solid #dc3545;'>";
        echo "❌ <b>خطا در Include:</b><br>";
        echo $e->getMessage();
        echo "</div>";
    }
} else {
    echo "<div style='background:#fff3cd;padding:15px;border-left:4px solid #ffc107;'>";
    echo "⚠️ <b>ابتدا خطاهای Syntax را رفع کنید!</b>";
    echo "</div>";
}

echo "<hr>";

// 3. بررسی bot.php
echo "<h2>3️⃣ بررسی bot.php</h2>";

if(file_exists('bot.php')) {
    $bot_content = file_get_contents('bot.php');
    $lines = explode("\n", $bot_content);
    
    echo "📄 تعداد خطوط: " . count($lines) . "<br>";
    echo "📦 حجم: " . number_format(strlen($bot_content)) . " بایت<br><br>";
    
    echo "<b>10 خط اول:</b><br>";
    echo "<pre style='background:#f8f9fa;padding:10px;'>";
    for($i = 0; $i < min(10, count($lines)); $i++) {
        echo htmlspecialchars($lines[$i]) . "\n";
    }
    echo "</pre>";
    
    // چک include ها
    echo "<b>Include های موجود:</b><br>";
    foreach($lines as $line) {
        if(strpos($line, 'include') !== false) {
            echo "<code>" . htmlspecialchars(trim($line)) . "</code><br>";
        }
    }
}

echo "<hr>";

// 4. راهنمای حل مشکل
echo "<h2>📋 راهنمای حل مشکل</h2>";

echo "<div style='background:#e7f3ff;padding:15px;border-left:4px solid #007bff;'>";
echo "<b>اگر همه چیز سبز بود ولی ربات کار نکرد:</b><br><br>";
echo "1. Webhook رو دوباره تنظیم کنید:<br>";
echo "&nbsp;&nbsp;&nbsp;<a href='setWebhook.php' target='_blank'>setWebhook.php</a><br><br>";
echo "2. وب‌هوک رو چک کنید:<br>";
echo "&nbsp;&nbsp;&nbsp;<a href='https://api.telegram.org/bot8229815851:AAFOkuuP775Mf67MWTPGci3UZboDd7WNcOs/getWebhookInfo' target='_blank'>getWebhookInfo</a><br><br>";
echo "3. به ربات /start بزنید<br><br>";
echo "4. اگر باز کار نکرد، فایل‌های جدید رو موقتاً غیرفعال کنید";
echo "</div>";

echo "<hr>";
echo "<p style='text-align:center;color:#666;'>✅ بررسی کامل شد - " . date('Y/m/d H:i:s') . "</p>";
?>
