<?php
echo "<html><head><meta charset='utf-8'></head><body style='font-family:tahoma;padding:20px;'>";
echo "<h1>🔧 رفع خودکار همه مشکلات</h1>";
echo "<hr>";

$fixes = [];
$errors = [];

// 1. ساخت فایل messagewizwiz.json
echo "<h2>1️⃣ ساخت فایل messagewizwiz.json</h2>";
$json_file = 'settings/messagewizwiz.json';
if(!file_exists($json_file)) {
    $content = json_encode(['offset' => -1, 'text' => ''], JSON_PRETTY_PRINT);
    if(file_put_contents($json_file, $content)) {
        echo "<p style='color:green;'>✅ فایل ساخته شد</p>";
        $fixes[] = 'messagewizwiz.json ساخته شد';
    } else {
        echo "<p style='color:red;'>❌ خطا در ساخت فایل</p>";
        $errors[] = 'نتوانست messagewizwiz.json بسازد';
    }
} else {
    echo "<p style='color:blue;'>ℹ️ فایل از قبل وجود دارد</p>";
}

// 2. بررسی و رفع مشکل bot.php
echo "<hr><h2>2️⃣ بررسی bot.php</h2>";

// خواندن محتوای bot.php
$bot_content = file_get_contents('bot.php');

// بررسی کامنت check()
if(strpos($bot_content, '// check();') !== false) {
    echo "<p style='color:green;'>✅ تابع check() کامنت شده</p>";
} else if(strpos($bot_content, 'check();') !== false) {
    echo "<p style='color:orange;'>⚠️ تابع check() هنوز فعال است</p>";
    echo "<p>در حال کامنت کردن...</p>";
    
    $bot_content = str_replace(
        "check();\n",
        "// check(); // غیرفعال شد برای رفع مشکل\n",
        $bot_content
    );
    
    if(file_put_contents('bot.php', $bot_content)) {
        echo "<p style='color:green;'>✅ check() کامنت شد</p>";
        $fixes[] = 'تابع check() غیرفعال شد';
    }
}

// 3. تست Syntax
echo "<hr><h2>3️⃣ تست Syntax</h2>";
$syntax_ok = true;
try {
    $tokens = @token_get_all($bot_content);
    echo "<p style='color:green;'>✅ Syntax صحیح است</p>";
} catch (ParseError $e) {
    echo "<p style='color:red;'>❌ خطای Syntax:</p>";
    echo "<pre>" . htmlspecialchars($e->getMessage()) . "</pre>";
    echo "<p>خط: " . $e->getLine() . "</p>";
    $syntax_ok = false;
    $errors[] = 'خطای Syntax در bot.php';
}

// 4. پاک کردن لاگ خطاها
echo "<hr><h2>4️⃣ پاک کردن لاگ خطاها</h2>";
$log_file = 'settings/error_log';
if(file_exists($log_file)) {
    file_put_contents($log_file, '');
    echo "<p style='color:green;'>✅ لاگ خطاها پاک شد</p>";
    $fixes[] = 'لاگ خطاها پاک شد';
}

// 5. تنظیم مجدد Webhook
echo "<hr><h2>5️⃣ تنظیم Webhook</h2>";
include_once 'baseInfo.php';

// حذف webhook
$url = "https://api.telegram.org/bot$botToken/deleteWebhook";
@file_get_contents($url);
echo "<p>✅ Webhook قدیمی حذف شد</p>";

sleep(1);

// تنظیم webhook جدید
$webhook_url = $botUrl . "bot.php";
$url = "https://api.telegram.org/bot$botToken/setWebhook?url=" . urlencode($webhook_url);
$response = @file_get_contents($url);
$data = json_decode($response, true);

if($data['ok']) {
    echo "<p style='color:green;'>✅ Webhook تنظیم شد: $webhook_url</p>";
    $fixes[] = 'Webhook تنظیم شد';
} else {
    echo "<p style='color:red;'>❌ خطا در تنظیم Webhook</p>";
    $errors[] = 'مشکل در تنظیم Webhook';
}

// 6. پاک کردن آپدیت‌های معلق
echo "<hr><h2>6️⃣ پاک کردن آپدیت‌های معلق</h2>";
$url = "https://api.telegram.org/bot$botToken/getUpdates?offset=-1";
@file_get_contents($url);
echo "<p style='color:green;'>✅ آپدیت‌های معلق پاک شدند</p>";
$fixes[] = 'آپدیت‌های معلق پاک شدند';

// نتیجه نهایی
echo "<hr>";
echo "<h2>📊 نتیجه نهایی</h2>";

if(empty($errors)) {
    echo "<div style='background:#d4edda;padding:20px;border-radius:10px;border:2px solid #28a745;'>";
    echo "<h3 style='color:#155724;'>✅ همه مشکلات برطرف شد!</h3>";
    echo "<ul>";
    foreach($fixes as $fix) {
        echo "<li>✅ $fix</li>";
    }
    echo "</ul>";
    echo "<h3>🎉 حالا ربات باید کار کند!</h3>";
    echo "<p><strong>مرحله بعدی:</strong></p>";
    echo "<ol>";
    echo "<li>به ربات در تلگرام بروید</li>";
    echo "<li>دستور <code>/start</code> را ارسال کنید</li>";
    echo "<li>باید منوی اصلی را ببینید!</li>";
    echo "</ol>";
    echo "</div>";
    
    // ارسال پیام تست
    echo "<hr><h2>7️⃣ ارسال پیام تست</h2>";
    $test = @file_get_contents("https://api.telegram.org/bot$botToken/sendMessage?chat_id=$admin&text=" . urlencode("✅ ربات آماده است!\n\nهمه مشکلات برطرف شد.\nحالا /start را امتحان کنید."));
    if($test) {
        echo "<p style='color:green;'>✅ پیام تست به ادمین ارسال شد</p>";
    }
} else {
    echo "<div style='background:#f8d7da;padding:20px;border-radius:10px;border:2px solid #dc3545;'>";
    echo "<h3 style='color:#721c24;'>⚠️ برخی مشکلات باقی ماندند:</h3>";
    echo "<ul>";
    foreach($errors as $error) {
        echo "<li>❌ $error</li>";
    }
    echo "</ul>";
    echo "</div>";
}

echo "<hr>";
echo "<div style='text-align:center;'>";
echo "<a href='test_bot.php' style='background:#17a2b8;color:white;padding:15px 30px;text-decoration:none;border-radius:8px;font-size:18px;display:inline-block;margin:10px;'>🔍 تست ربات</a>";
echo "</div>";

echo "</body></html>";
?>
