<?php
/**
 * Account Manager - مدیریت اکانت‌های VIP کاربران
 */

require_once 'auto_account_creator.php';

// نمایش لیست اکانت‌های کاربر
if($data == 'myVipAccounts') {
    $accounts = getUserAccounts($from_id);
    
    if(empty($accounts)) {
        $message = "📭 <b>شما هنوز اکانت VIP ندارید!</b>

━━━━━━━━━━━━━━━━━━━━━━

🔥 برای خرید اکانت VIP به منوی خرید مراجعه کنید.";
        
        $keyboard = [];
        $keyboard[] = [['text' => '🛒 خرید پلن VIP', 'callback_data' => 'vipPlans']];
        $keyboard[] = [['text' => $buttonValues['back_to_main'], 'callback_data' => 'mainMenu']];
        
        sendMessage($message, json_encode(['inline_keyboard' => $keyboard]), 'HTML');
        exit;
    }
    
    $message = "📱 <b>لیست اکانت‌های VIP شما</b>

━━━━━━━━━━━━━━━━━━━━━━\n\n";
    
    $keyboard = [];
    $active_count = 0;
    $expired_count = 0;
    
    foreach($accounts as $index => $account) {
        $num = $index + 1;
        $status_icon = '';
        $status_text = '';
        
        if($account['status'] == 'active') {
            // بررسی تاریخ انقضا
            if($account['expire_date'] < time()) {
                $status_icon = '🔴';
                $status_text = 'منقضی شده';
                $expired_count++;
            } else {
                $status_icon = '🟢';
                $status_text = 'فعال';
                $active_count++;
            }
        } elseif($account['status'] == 'expired') {
            $status_icon = '🔴';
            $status_text = 'منقضی شده';
            $expired_count++;
        } elseif($account['status'] == 'deleted') {
            $status_icon = '⚫';
            $status_text = 'حذف شده';
        } elseif($account['status'] == 'suspended') {
            $status_icon = '🟡';
            $status_text = 'معلق';
        }
        
        $volume_text = $account['volume_gb'] == 0 ? 'نامحدود' : $account['volume_gb'] . ' گیگ';
        $expire_text = date('Y/m/d', $account['expire_date']);
        
        $message .= "{$num}. {$status_icon} <b>{$account['email']}</b>\n";
        $message .= "   📦 حجم: {$volume_text} | ⏰ انقضا: {$expire_text}\n";
        $message .= "   وضعیت: {$status_text}\n\n";
        
        $keyboard[] = [['text' => "{$num}. {$status_icon} " . substr($account['email'], 0, 25), 'callback_data' => "viewVipAccount_{$account['id']}"]];
    }
    
    $message .= "━━━━━━━━━━━━━━━━━━━━━━\n\n";
    $message .= "✅ فعال: {$active_count} | ❌ منقضی: {$expired_count}\n\n";
    $message .= "💡 برای مشاهده جزئیات و لینک، روی اکانت کلیک کنید.";
    
    $keyboard[] = [['text' => '🔄 بروزرسانی', 'callback_data' => 'myVipAccounts']];
    $keyboard[] = [['text' => $buttonValues['back_to_main'], 'callback_data' => 'mainMenu']];
    
    sendMessage($message, json_encode(['inline_keyboard' => $keyboard]), 'HTML');
    exit;
}

// نمایش جزئیات یک اکانت
if(preg_match('/^viewVipAccount_(\d+)$/', $data, $match)) {
    $account_id = $match[1];
    
    // دریافت اطلاعات اکانت
    $stmt = $connection->prepare("SELECT * FROM `vip_accounts` WHERE `id` = ? AND `user_id` = ?");
    $stmt->bind_param("ii", $account_id, $from_id);
    $stmt->execute();
    $account = $stmt->get_result()->fetch_assoc();
    $stmt->close();
    
    if(!$account) {
        alert("❌ اکانت یافت نشد!");
        exit;
    }
    
    // دریافت اطلاعات زنده از سرور
    $server_status = checkAccountStatus($account['email']);
    
    $status_icon = $account['status'] == 'active' ? '🟢' : '🔴';
    $volume_text = $account['volume_gb'] == 0 ? 'نامحدود' : $account['volume_gb'] . ' گیگ';
    $expire_text = date('Y/m/d H:i', $account['expire_date']);
    $created_text = date('Y/m/d H:i', $account['created_at']);
    
    $message = "{$status_icon} <b>جزئیات اکانت</b>

━━━━━━━━━━━━━━━━━━━━━━

📧 <b>نام اکانت:</b>
<code>{$account['email']}</code>

🆔 <b>UUID:</b>
<code>{$account['uuid']}</code>

📦 <b>حجم کل:</b> {$volume_text}
⏱ <b>مدت زمان:</b> {$account['days']} روز
📅 <b>تاریخ انقضا:</b> {$expire_text}
📆 <b>تاریخ ساخت:</b> {$created_text}

━━━━━━━━━━━━━━━━━━━━━━\n\n";
    
    if($server_status) {
        $message .= "📊 <b>وضعیت زنده از سرور:</b>\n\n";
        $message .= "⬆️ آپلود: {$server_status['upload']}\n";
        $message .= "⬇️ دانلود: {$server_status['download']}\n";
        $message .= "📦 مجموع: {$server_status['total']}\n";
        $message .= "✅ وضعیت: " . ($server_status['enable'] ? 'فعال' : 'غیرفعال') . "\n\n";
        $message .= "━━━━━━━━━━━━━━━━━━━━━━\n\n";
    }
    
    if(!empty($account['vless_link'])) {
        $message .= "🔗 <b>لینک اتصال:</b>\n";
        $message .= "<code>{$account['vless_link']}</code>\n\n";
        $message .= "💡 <i>روی لینک بالا کلیک کنید تا کپی شود</i>\n\n";
    }
    
    $message .= "📱 <b>راهنمای اتصال:</b>\n";
    $message .= "1️⃣ نرم‌افزار V2Ray نصب کنید\n";
    $message .= "2️⃣ روی لینک کلیک کنید\n";
    $message .= "3️⃣ اتصال را برقرار کنید";
    
    $keyboard = [];
    
    // دکمه‌های مدیریت
    if($account['status'] == 'active' && $account['expire_date'] > time()) {
        // اکانت فعال
        $keyboard[] = [['text' => '📊 بررسی مصرف', 'callback_data' => "checkVipUsage_{$account_id}"]];
        //$keyboard[] = [['text' => '🔄 تمدید اکانت', 'callback_data' => "renewVipAccount_{$account_id}"]];
    }
    
    $keyboard[] = [['text' => '🔙 بازگشت به لیست', 'callback_data' => 'myVipAccounts']];
    $keyboard[] = [['text' => $buttonValues['back_to_main'], 'callback_data' => 'mainMenu']];
    
    sendMessage($message, json_encode(['inline_keyboard' => $keyboard]), 'HTML');
    exit;
}

// بررسی مصرف اکانت
if(preg_match('/^checkVipUsage_(\d+)$/', $data, $match)) {
    $account_id = $match[1];
    
    $stmt = $connection->prepare("SELECT * FROM `vip_accounts` WHERE `id` = ? AND `user_id` = ?");
    $stmt->bind_param("ii", $account_id, $from_id);
    $stmt->execute();
    $account = $stmt->get_result()->fetch_assoc();
    $stmt->close();
    
    if(!$account) {
        alert("❌ اکانت یافت نشد!");
        exit;
    }
    
    sendMessage("⏳ در حال دریافت اطلاعات از سرور...", null, null);
    
    $server_status = checkAccountStatus($account['email']);
    
    if(!$server_status) {
        alert("⚠️ خطا در دریافت اطلاعات از سرور!");
        exit;
    }
    
    $volume_text = $account['volume_gb'] == 0 ? 'نامحدود' : $account['volume_gb'] . ' گیگ';
    
    $message = "📊 <b>گزارش مصرف اکانت</b>

━━━━━━━━━━━━━━━━━━━━━━

📧 <b>اکانت:</b> <code>{$account['email']}</code>

📦 <b>حجم کل:</b> {$volume_text}

━━━━━━━━━━━━━━━━━━━━━━

⬆️ <b>آپلود:</b> {$server_status['upload']}
⬇️ <b>دانلود:</b> {$server_status['download']}
📦 <b>مجموع مصرف:</b> {$server_status['total']}

━━━━━━━━━━━━━━━━━━━━━━

✅ <b>وضعیت:</b> " . ($server_status['enable'] ? '🟢 فعال' : '🔴 غیرفعال') . "
⏰ <b>انقضا:</b> {$server_status['expiry']}

━━━━━━━━━━━━━━━━━━━━━━

🔄 به‌روزرسانی شده: " . date('Y/m/d H:i');
    
    $keyboard = [];
    $keyboard[] = [['text' => '🔄 بروزرسانی', 'callback_data' => "checkVipUsage_{$account_id}"]];
    $keyboard[] = [['text' => '🔙 بازگشت', 'callback_data' => "viewVipAccount_{$account_id}"]];
    
    sendMessage($message, json_encode(['inline_keyboard' => $keyboard]), 'HTML');
    exit;
}

// تمدید اکانت (در صورت نیاز)
if(preg_match('/^renewVipAccount_(\d+)$/', $data, $match)) {
    $account_id = $match[1];
    
    $stmt = $connection->prepare("SELECT * FROM `vip_accounts` WHERE `id` = ? AND `user_id` = ?");
    $stmt->bind_param("ii", $account_id, $from_id);
    $stmt->execute();
    $account = $stmt->get_result()->fetch_assoc();
    $stmt->close();
    
    if(!$account) {
        alert("❌ اکانت یافت نشد!");
        exit;
    }
    
    // اینجا می‌تونی منطق تمدید رو اضافه کنی
    $message = "🔄 <b>تمدید اکانت</b>

━━━━━━━━━━━━━━━━━━━━━━

این قابلیت به زودی اضافه خواهد شد!

برای تمدید اکانت، یک پلن جدید خریداری کنید.";
    
    $keyboard = [];
    $keyboard[] = [['text' => '🛒 خرید پلن جدید', 'callback_data' => 'vipPlans']];
    $keyboard[] = [['text' => '🔙 بازگشت', 'callback_data' => "viewVipAccount_{$account_id}"]];
    
    sendMessage($message, json_encode(['inline_keyboard' => $keyboard]), 'HTML');
    exit;
}
