# یادداشت‌های به‌روزرسانی ربات - نسخه جدید

## تاریخ: 29 نوامبر 2025

### تغییرات اعمال شده:

#### 1️⃣ حذف دکمه "سرویس‌های من" قدیمی
- دکمه قدیمی `📦 سرویس‌های من` از منوی اصلی حذف شد
- این دکمه تکراری بود و با دکمه "سرویس‌های من" موجود در `mySubscriptions` یکسان عمل می‌کرد

#### 2️⃣ تغییر نام VPN به APN
- **قبل:** `🔥 خرید سرویس VPN`
- **بعد:** `🔥 خرید سرویس APN`
- تمام متن‌ها و پیام‌های مربوط به VPN به APN تغییر یافت

#### 3️⃣ تغییر نمایش محتوا از بالا به پایین
تمام صفحات کلیدی ربات به‌روزرسانی شدند تا به جای `editText` (که محتوا را بالای صفحه نمایش می‌دهد)، از `delMessage + sendMessage` استفاده کنند:

**صفحات به‌روزرسانی شده:**
- ✅ صفحه خرید سرویس (`buyService`)
- ✅ صفحه نمایش تعرفه‌ها (`showPlansInCategory`)
- ✅ صفحه تایید خرید (`buyPlan`)
- ✅ صفحه پشتیبانی و تیکت‌ها (`supportSection`)
- ✅ صفحه اطلاعات کاربر (`myInfo`)
- ✅ صفحه سرویس‌های من (`mySubscriptions`)
- ✅ صفحه ثبت تیکت جدید (`usersNewTicket`)

#### 4️⃣ فیکس دکمه‌های بازگشت
- دکمه بازگشت در صفحه ثبت تیکت جدید، حالا به `supportSection` برمی‌گردد (به جای `mainMenu`)
- مسیرهای بازگشت در تمام صفحات بهینه‌سازی شد

#### 5️⃣ تکمیل جریان خرید و پرداخت

**مسیرهای پرداخت:**

##### 🔹 پرداخت از کیف پول:
1. کاربر پلن را انتخاب می‌کند
2. دکمه "پرداخت از کیف پول" را می‌زند
3. سیستم موجودی را چک می‌کند
4. در صورت کافی بودن، مبلغ کسر می‌شود
5. سرویس به صورت اتوماتیک ساخته می‌شود
6. کانفیگ به کاربر ارسال می‌شود

##### 🔹 پرداخت با فیش بانکی:
1. کاربر پلن را انتخاب می‌کند
2. دکمه "پرداخت فیش بانکی" را می‌زند
3. فیش را آپلود می‌کند
4. فیش به ادمین ارسال می‌شود
5. ادمین دو گزینه دارد:
   - ✅ **تایید**: سرویس ساخته می‌شود و به کاربر ارسال می‌گردد
   - ❌ **رد**: پرداخت رد می‌شود و به کاربر اطلاع داده می‌شود

**ویژگی‌های جدید:**
- ✅ تایید و رد پرداخت توسط ادمین
- ✅ ارسال اتوماتیک کانفیگ به کاربر پس از تایید
- ✅ اطلاع‌رسانی به کاربر در صورت رد پرداخت
- ✅ دکمه "دریافت کانفیگ" برای مشاهده مجدد اطلاعات سرویس
- ✅ نمایش UUID و لینک کانفیگ
- ✅ راهنمای اتصال و دکمه تمدید سرویس

#### 6️⃣ فیکس جدول کاربران
- تابع `createServiceAccount` حالا از جدول `users` به جای `user` استفاده می‌کند
- مشکل دریافت اطلاعات کاربر برطرف شد

### جداول دیتابیس مورد نیاز:

#### `temp_service_purchases`
```sql
CREATE TABLE IF NOT EXISTS `temp_service_purchases` (
    `id` INT AUTO_INCREMENT PRIMARY KEY,
    `hash_id` VARCHAR(255) NOT NULL,
    `user_id` INT NOT NULL,
    `plan_id` INT NOT NULL,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX `idx_hash` (`hash_id`),
    INDEX `idx_user` (`user_id`)
);
```

#### `service_orders`
```sql
CREATE TABLE IF NOT EXISTS `service_orders` (
    `id` INT AUTO_INCREMENT PRIMARY KEY,
    `user_id` INT NOT NULL,
    `plan_id` INT NOT NULL,
    `server_id` INT NOT NULL,
    `hash_id` VARCHAR(255),
    `email` VARCHAR(255) NOT NULL,
    `uuid` VARCHAR(255),
    `inbound_id` INT,
    `config_link` TEXT,
    `volume_gb` INT,
    `days` INT,
    `price` INT,
    `expire_date` DATETIME,
    `status` ENUM('active', 'expired', 'suspended') DEFAULT 'active',
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX `idx_user` (`user_id`),
    INDEX `idx_hash` (`hash_id`),
    INDEX `idx_status` (`status`)
);
```

### نحوه تست:

1. **تست خرید با کیف پول:**
   ```
   /start -> خرید سرویس APN -> انتخاب دسته -> انتخاب پلن -> پرداخت از کیف پول
   ```

2. **تست خرید با فیش:**
   ```
   /start -> خرید سرویس APN -> انتخاب دسته -> انتخاب پلن -> پرداخت فیش بانکی -> آپلود فیش
   سپس به عنوان ادمین: تایید یا رد پرداخت
   ```

3. **تست نمایش از پایین:**
   ```
   هر دکمه‌ای را بزنید، باید پیام جدید از پایین ظاهر شود نه از بالا
   ```

### نکات مهم:

⚠️ **قبل از استفاده، حتما جداول مورد نیاز را ایجاد کنید**
⚠️ **API سرور VPS باید فعال و در دسترس باشد**
⚠️ **پوشه `logs` برای ثبت لاگ‌ها ایجاد می‌شود**

### فایل‌های تغییر یافته:

1. `bot.php` - هسته اصلی ربات
2. `config.php` - تنظیمات منوی اصلی
3. `service_creator.php` - سیستم ساخت سرویس

### مشکلات برطرف شده:

✅ دکمه "سرویس‌های من" تکراری حذف شد
✅ نام VPN به APN تغییر یافت
✅ نمایش محتوا از پایین به جای بالا
✅ دکمه‌های بازگشت درست کار می‌کنند
✅ جریان خرید کامل و قابل استفاده است
✅ تایید و رد پرداخت توسط ادمین
✅ ارسال اتوماتیک کانفیگ پس از خرید

---

**توسعه‌دهنده:** GitHub Copilot  
**تاریخ:** 29 نوامبر 2025
