# راهنمای سیستم مدیریت فروش پلن‌های Trading

## ✅ تغییرات انجام شده

### 1️⃣ پلن‌های جدید آی‌پی ثابت آلمان

پلن‌های Trading با قیمت‌های جدید و مشخصات بروز شده:

| پلن | حجم | مدت | تعداد کاربر | قیمت |
|-----|------|------|-------------|------|
| یک ماهه | 45 گیگ | 30 روز | 1-2 کاربر | 180,000 تومان |
| سه ماهه | 130 گیگ | 90 روز | 1-2 کاربر | 480,000 تومان |
| شش ماهه | 260 گیگ | 180 روز | 1-2 کاربر | 900,000 تومان |

**ویژگی‌ها:**
- 🇩🇪 آی‌پی ثابت آلمان
- ⚡️ پینگ پایین (< 10ms)
- 💹 بهینه برای Binance، Bybit، OKX
- 📈 پشتیبانی MetaTrader و TradingView
- 📊 آپتایم 99.9%

---

## 2️⃣ سیستم مدیریت فروش

### دسترسی به پنل مدیریت

1. وارد ربات شوید
2. به **پنل ادمین** بروید
3. روی **📊 مدیریت فروش پلن‌های ترید** کلیک کنید

### امکانات پنل

✅ **مشاهده وضعیت همه پلن‌ها:**
- پلن‌های فعال: ✅ سبز
- پلن‌های غیرفعال: ❌ قرمز

✅ **فعال/غیرفعال کردن پلن‌ها:**
- روی هر پلن کلیک کنید
- وضعیت آن تغییر می‌کند
- تغییرات فوری اعمال می‌شود

### چگونه کار می‌کند؟

#### برای ادمین:
1. پلن‌هایی که موجودی ندارند را غیرفعال کنید
2. پلن‌های غیرفعال برای کاربران نمایش داده نمی‌شوند
3. وقتی موجودی تأمین شد، دوباره فعال کنید

#### برای کاربران:
- فقط پلن‌های فعال را می‌بینند
- اگر پلنی غیرفعال باشد، در لیست نیست
- پیام مناسب نمایش داده می‌شود اگر پلنی موجود نباشد

---

## 3️⃣ نصب و راه‌اندازی

### مرحله 1: آپدیت دیتابیس

```
http://yourdomain.com/update_trading_tables.php
```

این فایل:
- جدول `trading_plans_status` را می‌سازد
- پلن‌های پیش‌فرض را با وضعیت فعال ثبت می‌کند

### مرحله 2: تست سیستم

1. وارد ربات شوید
2. بخش **پلن‌های ترید** را باز کنید
3. باید 3 پلن جدید را ببینید

### مرحله 3: تست پنل مدیریت

1. وارد پنل ادمین شوید
2. روی **مدیریت فروش پلن‌های ترید** کلیک کنید
3. یک پلن را غیرفعال کنید
4. از حساب عادی (غیر ادمین) چک کنید
5. پلن غیرفعال نباید نمایش داده شود

---

## 4️⃣ ساختار فایل‌ها

### فایل‌های اصلی:

1. **`trading_plans_handler.php`**
   - تعریف پلن‌ها
   - توابع مدیریت فروش
   - هندلرهای callback

2. **`config.php`**
   - اضافه شدن دکمه به پنل ادمین
   - تابع `getAdminKeys()` بروز شده

3. **`createTables.php`**
   - تعریف جدول `trading_plans_status`

4. **`update_trading_tables.php`**
   - اسکریپت آپدیت دیتابیس
   - درج داده‌های پیش‌فرض

---

## 5️⃣ ساختار دیتابیس

### جدول `trading_plans_status`

```sql
CREATE TABLE `trading_plans_status` (
  `id` int(11) AUTO_INCREMENT,
  `plan_key` varchar(50) UNIQUE,
  `enabled` tinyint(1) DEFAULT 1,
  `updated_at` timestamp,
  PRIMARY KEY (`id`)
)
```

**فیلدها:**
- `plan_key`: شناسه منحصر به فرد پلن (مثل trading1)
- `enabled`: وضعیت فروش (1 = فعال، 0 = غیرفعال)
- `updated_at`: زمان آخرین تغییر

---

## 6️⃣ سناریوهای استفاده

### سناریو 1: تمام شدن موجودی پلن

**مشکل:** پلن 6 ماهه تمام شد
**راه‌حل:**
1. وارد پنل مدیریت شوید
2. روی "260 گیگ شش ماهه" کلیک کنید
3. وضعیت به ❌ غیرفعال تغییر می‌کند
4. کاربران دیگر این پلن را نمی‌بینند

### سناریو 2: تأمین مجدد موجودی

**مشکل:** موجودی پلن 3 ماهه تأمین شد
**راه‌حل:**
1. وارد پنل مدیریت شوید
2. روی "130 گیگ سه ماهه" کلیک کنید
3. وضعیت به ✅ فعال تغییر می‌کند
4. پلن دوباره قابل خرید است

### سناریو 3: تعطیلات

**مشکل:** می‌خواهید موقتاً فروش Trading را متوقف کنید
**راه‌حل:**
1. همه پلن‌ها را غیرفعال کنید
2. کاربران پیام "در حال حاضر پلنی موجود نیست" را می‌بینند
3. وقت برگشتید، دوباره فعال کنید

---

## 7️⃣ نکات مهم

⚠️ **توجه‌ها:**
- تغییرات فوری اعمال می‌شوند
- نیازی به ریستارت ربات نیست
- ادمین‌ها همیشه همه پلن‌ها را می‌بینند
- لاگ تغییرات خودکار ثبت می‌شود

✅ **بهترین شیوه‌ها:**
- قبل از غیرفعال کردن، به کاربران اطلاع دهید
- پلن‌های پرطرفدار را همیشه فعال نگه دارید
- به صورت دوره‌ای موجودی را چک کنید
- از پنل مدیریت برای کنترل استفاده کنید

---

## 8️⃣ پشتیبانی و مشکلات

### مشکلات رایج

**مشکل 1:** دکمه مدیریت فروش نیست
- **راه‌حل:** مطمئن شوید config.php آپدیت شده

**مشکل 2:** خطای دیتابیس
- **راه‌حل:** update_trading_tables.php را اجرا کنید

**مشکل 3:** پلن‌ها نمایش داده نمی‌شوند
- **راه‌حل:** چک کنید همه پلن‌ها غیرفعال نباشند

---

## 9️⃣ توسعه آینده

امکانات پیشنهادی:
- [ ] تعیین تعداد موجودی برای هر پلن
- [ ] اعلان خودکار وقتی موجودی کم شد
- [ ] گزارش فروش به تفکیک پلن
- [ ] برنامه‌ریزی فعال/غیرفعال شدن خودکار
- [ ] سیستم پیش‌فروش

---

**نسخه:** 1.0  
**تاریخ:** نوامبر 2025  
**توسط:** GitHub Copilot

---

## 🆘 نیاز به کمک؟

اگر سوالی دارید یا مشکلی پیش آمد:
1. لاگ خطاها را چک کنید
2. مطمئن شوید دیتابیس آپدیت شده
3. webhook را دوباره ست کنید
4. با پشتیبانی تماس بگیرید
