# 📋 راهنمای نهایی استقرار سیستم جدید

## ✅ تغییرات انجام شده

### 🆕 فایل‌های جدید ایجاد شده:
1. **server_manager.php** - مدیریت سرورها، دسته‌بندی‌ها و تعرفه‌ها
2. **service_creator.php** - ساخت اتوماتیک سرویس VPN برای کاربران
3. **install_new_system.php** - نصب کننده دیتابیس (5 جدول جدید)

### 🔄 فایل‌های ویرایش شده:
1. **bot.php**
   - خط 1-8: Include فایل‌های جدید (حذف vip_plans_handler، اضافه server_manager و service_creator)
   - خط 9050+: هندلرهای جدید خرید سرویس (buyService, showPlansInCategory, buyPlan, payFromWallet, payByReceipt, approveServicePayment)

2. **config.php**
   - خط 247-265: آپدیت getMainKeys() - تغییر "خرید پلن VIP" به "خرید سرویس VPN" و اضافه "سرویس‌های من"
   - خط 321-346: آپدیت getAdminKeys() - اضافه دکمه‌های "مدیریت سرورها"، "مدیریت دسته‌بندی‌ها"، "مدیریت تعرفه‌ها"

3. **install_new_system.php**
   - جدول جدید: temp_service_purchases برای مدیریت خریدهای در حال انتظار

---

## 🗄️ ساختار دیتابیس جدید

### 📊 5 جدول جدید:

#### 1️⃣ `servers` - اطلاعات سرورها
```sql
- id, name, server_ip, panel_port, panel_path
- panel_username, panel_password, protocol
- inbound_id, location, status
```

#### 2️⃣ `plan_categories` - دسته‌بندی تعرفه‌ها
```sql
- id, name, emoji, sort_order, status
```

#### 3️⃣ `service_plans` - تعرفه‌های سرویس
```sql
- id, category_id, server_id, name
- volume_gb, days, price, user_limit
- description, status
```

#### 4️⃣ `service_orders` - سفارشات کاربران
```sql
- id, user_id, plan_id, server_id
- hash_id, email, uuid, inbound_id
- config_link, volume_gb, days, price
- expire_date, status
```

#### 5️⃣ `temp_service_purchases` - خریدهای موقت (فیش بانکی)
```sql
- id, hash_id, user_id, plan_id, created_at
```

---

## 🚀 مراحل استقرار (گام به گام)

### مرحله 1️⃣: آپلود فایل‌ها
```
آپلود به https://apnlot.ir/robotali/
├── server_manager.php ✨ جدید
├── service_creator.php ✨ جدید
├── install_new_system.php ✨ جدید
├── bot.php ✏️ ویرایش شده
└── config.php ✏️ ویرایش شده
```

### مرحله 2️⃣: نصب دیتابیس
```
🌐 مرورگر: https://apnlot.ir/robotali/install_new_system.php
انتظار خروجی:
✅ جدول servers ایجاد شد
✅ جدول plan_categories ایجاد شد
✅ جدول service_plans ایجاد شد
✅ جدول service_orders ایجاد شد
✅ جدول temp_service_purchases ایجاد شد
✅ سرور آلمان اضافه شد
✅ 3 دسته‌بندی اضافه شد
✅ 8 تعرفه اضافه شد
```

### مرحله 3️⃣: تست سیستم در تلگرام
```
1. باز کردن ربات
2. کلیک روی "🔥 خرید سرویس VPN"
3. انتخاب دسته (مثلا "پلن‌های یک ماهه 📅")
4. مشاهده لیست تعرفه‌ها
5. کلیک روی "🛒 خرید ..."
6. انتخاب "💳 پرداخت از کیف پول" یا "🏦 پرداخت فیش بانکی"
```

### مرحله 4️⃣: تست پنل ادمین
```
1. باز کردن منوی مدیریت
2. کلیک روی "🖥️ مدیریت سرورها"
3. کلیک روی "➕ افزودن سرور جدید"
4. وارد کردن اطلاعات سرور
5. ذخیره و بررسی

همینطور برای:
- "📦 مدیریت دسته‌بندی‌ها"
- "🎁 مدیریت تعرفه‌ها"
```

### مرحله 5️⃣: حذف فایل‌های قدیمی (اختیاری)
```
⚠️ فقط پس از اطمینان از کارکرد کامل سیستم جدید

حذف فایل‌ها:
❌ vip_plans_handler.php
❌ auto_account_creator.php
❌ account_manager.php
❌ vip_manual_config_handler.php
❌ install_vip_auto_system.php

نگه داشتن:
✅ bot.php
✅ config.php
✅ server_manager.php
✅ service_creator.php
✅ trading_plans_handler.php
✅ notification_system.php
✅ discount_system.php
✅ baseInfo.php
```

---

## 🔧 تست‌های پیشنهادی

### ✔️ تست 1: خرید با کیف پول
```
1. شارژ کیف پول (حداقل 40,000 تومان)
2. خرید تعرفه "20 گیگ یک ماهه"
3. بررسی پیام موفقیت
4. دریافت کانفیگ
5. بررسی جدول service_orders
```

### ✔️ تست 2: خرید با فیش بانکی
```
1. انتخاب تعرفه
2. ارسال عکس فیش
3. بررسی پیام به ادمین
4. تایید توسط ادمین
5. بررسی ساخت اتوماتیک سرویس
```

### ✔️ تست 3: افزودن سرور جدید
```
1. مدیریت سرورها > افزودن سرور
2. وارد کردن اطلاعات
3. ذخیره
4. بررسی جدول servers
```

### ✔️ تست 4: افزودن تعرفه جدید
```
1. مدیریت تعرفه‌ها > افزودن تعرفه
2. انتخاب دسته
3. انتخاب سرور
4. وارد کردن جزئیات
5. ذخیره
6. بررسی در لیست خرید
```

---

## 🆘 عیب‌یابی

### ❌ مشکل: "تعرفه یافت نشد"
```
✅ راه حل:
1. بررسی جدول service_plans
2. اطمینان از status='active'
3. بررسی وجود سرور فعال
```

### ❌ مشکل: "خطا در اتصال به سرور"
```
✅ راه حل:
1. بررسی VPS_API_URL در config.php
2. تست API: http://82.115.26.209/api/create_vip_account.php
3. بررسی فایل لاگ: logs/service_creation_[تاریخ].log
```

### ❌ مشکل: "موجودی کافی نیست"
```
✅ راه حل:
1. شارژ کیف پول از پنل ادمین
2. یا استفاده از فیش بانکی
```

### ❌ مشکل: "دسته‌بندی خالی است"
```
✅ راه حل:
1. مدیریت تعرفه‌ها > افزودن تعرفه
2. تخصیص تعرفه به دسته موردنظر
```

---

## 📞 پشتیبانی

### لاگ‌ها:
```
📁 logs/service_creation_[DATE].log
هر عملیات ساخت سرویس (موفق یا ناموفق) ثبت می‌شود
```

### دیتابیس:
```
🗄️ جدول service_orders: تمام سفارشات
🗄️ جدول temp_service_purchases: خریدهای در انتظار تایید
```

### API:
```
🌐 http://82.115.26.209/api/create_vip_account.php
🔑 apn_vip_2024_secure_key_xyz123
```

---

## ✨ ویژگی‌های جدید

✅ مدیریت چند سرور  
✅ افزودن/حذف دسته‌بندی  
✅ افزودن/حذف تعرفه  
✅ پرداخت از کیف پول  
✅ پرداخت با فیش بانکی  
✅ ساخت اتوماتیک سرویس  
✅ ارسال اتوماتیک کانفیگ  
✅ لیست سرویس‌های من  
✅ لاگ کامل عملیات  

---

## 🎯 نتیجه

🚀 سیستم جدید کاملاً دینامیک و قابل مدیریت است  
🔥 دیگر نیازی به ویرایش کد برای افزودن سرور یا تعرفه نیست  
💎 ادمین از داخل ربات همه چیز را مدیریت می‌کند  
⚡ ساخت اتوماتیک سرویس بدون دخالت ادمین  

**موفق باشید! 🎉**

سازنده: @NoovixCo
